/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.kernels;

import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.data.FileContext;
import de.uwemock.kernel.AbstractKernel;
import de.uwemock.xmltools.XmlTools;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class KernelImportAccounts
extends AbstractKernel<AccountList> {
    private String filename;

    public KernelImportAccounts(String filename) {
        this.filename = filename;
    }

    @Override
    public AccountList work() throws FileNotFoundException, IOException, XMLStreamException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        AccountList newAccountList = null;
        XMLStreamReader reader = null;
        Reader xmlReaderFromFileContext = null;
        FileInputStream fileInputStream = null;
        try {
            try {
                boolean hasNext;
                FileContext context = new FileContext(this.filename);
                xmlReaderFromFileContext = context.getXMLDataStream();
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                reader = inputFactory.createXMLStreamReader(xmlReaderFromFileContext);
                do {
                    if (reader.hasName() && reader.isStartElement() && XmlTools.isStartElement(reader, "accounts")) {
                        logger.finer("Found account list");
                        newAccountList = AccountList.readFromXML(reader);
                    }
                    if (!(hasNext = reader.hasNext())) continue;
                    reader.next();
                } while (hasNext);
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (XMLStreamException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException ex) {
                    ex.printStackTrace();
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return newAccountList;
    }
}

