/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.kernels;

import de.uwemock.csvtools.CsvTable;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.DepreciationInfoRecord;
import de.uwemock.eur.depreciation.formatter.ValueAtEndOfYearFormatter;
import de.uwemock.eur.depreciation.formatter.ValueAtStartOfYearFormatter;
import de.uwemock.eur.depreciation.formatter.ValueDepreciationLastYearFormatter;
import de.uwemock.eur.depreciation.formatter.ValueDepreciationNotLastYearFormatter;
import de.uwemock.eur.depreciation.formatter.ValueExtraDepreciationFormatter;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.kernels.HtmlContentsHelper;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.OldDepreciationPool;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.eur.receipt.builder.AmountSummer;
import de.uwemock.eur.receipt.formatter.ReceiptAmountFormatter;
import de.uwemock.eur.receipt.formatter.ReceiptContentsFormatter;
import de.uwemock.eur.receipt.formatter.ReceiptDescriptionFormatter;
import de.uwemock.eur.receipt.formatter.ReceiptElementFormatter;
import de.uwemock.htmltools.HtmlBodyElement;
import de.uwemock.htmltools.HtmlContainer;
import de.uwemock.htmltools.HtmlContext;
import de.uwemock.htmltools.HtmlLink;
import de.uwemock.htmltools.HtmlSimpleElement;
import de.uwemock.htmltools.HtmlTable;
import de.uwemock.htmltools.HtmlText;
import de.uwemock.kernel.AbstractKernel;
import de.uwemock.tools.LoggingManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class KernelDepreciationList
extends AbstractKernel<StringBuffer> {
    public static final String RESULT_HTML_DATA = "";
    public static final String RESULT_CSV_DATA = "";
    public static final String RESULT_RESULT_MAP = "resultmap";
    private ReceiptGroupManager receiptGroupManager;
    private int businessYear;
    private boolean createTestData;
    private Map<Integer, DepreciationResult> resultMap;

    public KernelDepreciationList(ReceiptGroupManager manager, int businessYear, boolean createTestData) {
        this.receiptGroupManager = manager;
        this.businessYear = businessYear;
        this.createTestData = createTestData;
        if (createTestData) {
            this.resultMap = new HashMap<Integer, DepreciationResult>();
            this.putData(RESULT_RESULT_MAP, this.resultMap);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StringBuffer work() {
        void var19_22;
        ReceiptContentsFormatter[] COLUMN_FORMATTER = new ReceiptContentsFormatter[]{new ReceiptElementFormatter(1), new ReceiptElementFormatter(2), new ReceiptDescriptionFormatter(), new ReceiptAmountFormatter(6, "amount"), new ValueAtStartOfYearFormatter(this.businessYear), new ValueExtraDepreciationFormatter(this.businessYear), new ValueDepreciationNotLastYearFormatter(this.businessYear), new ValueDepreciationLastYearFormatter(this.businessYear), new ValueAtEndOfYearFormatter(this.businessYear)};
        String[] COLUMN_ALIGNMENT = new String[]{"right", "left", "left", "right", "right", "right", "right", "right", "right"};
        boolean[] blArray = new boolean[9];
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        boolean[] COLUMN_NOWRAP = blArray;
        List<AbstractReceipt> receiptsToProcess = this.receiptGroupManager.getReceiptCollectionByTimeFrame(100);
        Iterator iterator = receiptsToProcess.iterator();
        while (iterator.hasNext()) {
            Receipt r = (Receipt)iterator.next();
            if (!r.hasDepreciationStrategy() || r instanceof OldDepreciationPool) {
                iterator.remove();
                continue;
            }
            if (!r.hasDepreciationStrategy() || r.getDepreciationStrategy().isDepreciatedInYear(this.businessYear)) continue;
            iterator.remove();
        }
        TreeSet<Integer> allAccounts = new TreeSet<Integer>();
        iterator = receiptsToProcess.iterator();
        while (iterator.hasNext()) {
            allAccounts.addAll(((AbstractReceipt)iterator.next()).accountNumbersAddedTo());
        }
        String depreciationCss = "body { font-family:Verdana,Arial,Helvetia,sans-serif; }\nh1 { }\nh3 { }\ntd.general_label { font-weight:bold; font-size:80%; }\ntd.general_contents { font-size:80%; }\nth { background-color:#e0e0e0; font-size:80%; }\ntr.row_even { background-color:#f0f0f0; font-size:80%; }\ntr.row_odd { background-color:#ffffff; font-size:80%; }\n.deleted { text-decoration:line-through; }\n.minitable { font-size:90%; }\ntd.leftcell { border-right:solid 1px black; }\ntd.rightcell { }\ntd.midcell { border-right:solid 1px black; }\ntd.total { font-family:monospace; font-weight:bold; text-align:right; }\n.amount { font-family:monospace; white-space:nowrap; }";
        String depreciationCssPrint = ".noprint { display:none; }\n";
        HtmlContext html = new HtmlContext();
        html.setTitle(TextPool.getString("htmlTitleDepreciationList"));
        html.addStyleSheet("all", depreciationCss);
        html.addStyleSheet("print", depreciationCssPrint);
        html.addElement(new HtmlSimpleElement("h1", null, null, null, String.valueOf(TextPool.getString("htmlTitleDepreciationList")) + " " + this.businessYear));
        html.addElement(DataCenter.getInstance().createGeneralDataHtmlTable());
        html.addLineBreak();
        HtmlContentsHelper.addSwitchDeleted(html);
        html.addLineBreak();
        String[] COLUMNS_DEPRECIATION_LIST = TextPool.getArray("COLUMNS_DEPRECIATION_LIST");
        HtmlTable htmlTable = new HtmlTable();
        CsvTable csvTable = new CsvTable();
        htmlTable.setBorder("1px solid black");
        htmlTable.setCellspacing("0px");
        htmlTable.setRowAsHeader(0, true);
        int i = 0;
        while (i < COLUMNS_DEPRECIATION_LIST.length) {
            htmlTable.setContents(i, 0, COLUMNS_DEPRECIATION_LIST[i]);
            htmlTable.setHeadline(i, 0, true);
            csvTable.setContents(i, 0, COLUMNS_DEPRECIATION_LIST[i]);
            ++i;
        }
        int y = 1;
        AmountSummer totalAmountDepreciated = new AmountSummer();
        AmountSummer totalExtraDepreciation = new AmountSummer();
        AmountSummer totalValueAtStartOfYear = new AmountSummer();
        AmountSummer totalAmountRemoved = new AmountSummer();
        AmountSummer totalValueAtEndOfYear = new AmountSummer();
        for (Receipt receipt : receiptsToProcess) {
            boolean isFinalDepreciationYear;
            if (y % 2 == 0) {
                htmlTable.setRowCssClass(y, "row_even");
            } else {
                htmlTable.setRowCssClass(y, "row_odd");
            }
            DepreciationInfoRecord info = receipt.getDepreciationStrategy().getInfoRecord(this.businessYear);
            BigDecimal valueAtStartOfYear = info.getAmountStartOfYear();
            BigDecimal extraDepreciationThisYear = info.getExtraDepreciation();
            BigDecimal valueDepreciatedThisYear = info.getDepreciation();
            BigDecimal valueAtEndOfYear = info.getAmountEndOfYear();
            if (this.createTestData) {
                DepreciationResult dr = new DepreciationResult(valueAtStartOfYear, valueDepreciatedThisYear, valueAtEndOfYear);
                this.resultMap.put(receipt.getNumber(), dr);
            }
            boolean bl = isFinalDepreciationYear = !receipt.getDepreciationStrategy().isDepreciatedInYear(this.businessYear + 1);
            if (isFinalDepreciationYear) {
                totalAmountRemoved.add(valueDepreciatedThisYear);
            } else {
                totalAmountDepreciated.add(valueDepreciatedThisYear);
            }
            totalExtraDepreciation.add(extraDepreciationThisYear);
            totalValueAtStartOfYear.add(valueAtStartOfYear);
            totalValueAtEndOfYear.add(valueAtEndOfYear);
            int x = 0;
            while (x < COLUMNS_DEPRECIATION_LIST.length) {
                HtmlBodyElement htmlContents = COLUMN_FORMATTER[x].getFormattedReceiptContentsAsHtml(receipt);
                if (receipt.isDeleted()) {
                    htmlContents.addCssClass("deleted");
                }
                if (!receipt.isPaid()) {
                    htmlContents.addCssClass("unpaid");
                }
                htmlTable.setContents(x, y, htmlContents);
                htmlTable.setAlign(x, y, COLUMN_ALIGNMENT[x]);
                htmlTable.setNoWrap(x, y, COLUMN_NOWRAP[x]);
                htmlTable.setVAlign(x, y, "top");
                String csvContents = COLUMN_FORMATTER[x].getFormattedReceiptContentsAsText(receipt);
                csvTable.setContents(x, y, csvContents);
                ++x;
            }
            ++y;
        }
        htmlTable.setContents(4, y, totalValueAtStartOfYear.getTotalAsHtml());
        htmlTable.setContents(5, y, totalExtraDepreciation.getTotalAsHtml());
        htmlTable.setContents(6, y, totalAmountDepreciated.getTotalAsHtml());
        htmlTable.setContents(7, y, totalAmountRemoved.getTotalAsHtml());
        htmlTable.setContents(8, y, totalValueAtEndOfYear.getTotalAsHtml());
        int n = 4;
        while (var19_22 <= 8) {
            htmlTable.setNoWrap((int)var19_22, y, true);
            htmlTable.setCssClass((int)var19_22, y, "total");
            ++var19_22;
        }
        html.addElement(htmlTable);
        html.addElement(DataCenter.getInstance().createGeneralInfoHtml());
        Calendar calendar = Calendar.getInstance();
        try {
            File file = File.createTempFile(String.valueOf(String.format("%4d-%02d-%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5))) + "_eur_receipts", ".csv");
            file.deleteOnExit();
            FileWriter writer = new FileWriter(file);
            writer.write(csvTable.toCsvString().toString());
            writer.flush();
            writer.close();
            HtmlLink link = new HtmlLink(file.getName());
            link.addHtmlElement(new HtmlText(TextPool.getString("htmlTextLinkToCsv")));
            HtmlContainer linkContainer = new HtmlContainer("p");
            linkContainer.addCssClass("noprint");
            linkContainer.addHtmlElement(link);
            html.addElement(linkContainer);
        }
        catch (IOException e1) {
            LoggingManager.logException(this.getClass(), e1);
        }
        this.putData("", html);
        this.putData("", csvTable);
        return html.toStringBuffer();
    }

    public static class DepreciationResult {
        public BigDecimal valueAtStartOfYear;
        public BigDecimal valueDepreciatedThisYear;
        public BigDecimal valueAtEndOfYear;

        public DepreciationResult(BigDecimal valueAtStartOfYear, BigDecimal valueDepreciatedThisYear, BigDecimal valueAtEndOfYear) {
            this.valueAtStartOfYear = valueAtStartOfYear;
            this.valueDepreciatedThisYear = valueDepreciatedThisYear;
            this.valueAtEndOfYear = valueAtEndOfYear;
        }
    }
}

