/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.kernels;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.htmltools.HtmlContext;
import de.uwemock.htmltools.HtmlTable;
import de.uwemock.kernel.AbstractKernel;

public class KernelAccountsList
extends AbstractKernel<StringBuffer> {
    public static final String RESULT_HTML_DATA = "";
    private AccountList accountList;

    public KernelAccountsList(AccountList accountList) {
        this.accountList = accountList;
    }

    @Override
    public StringBuffer work() {
        String accountsListCss = "body { font-family:Verdana,Arial,Helvetia,sans-serif; }\nh1 { }\ntd.general_label { font-weight:bold; font-size:80%; }\ntd.general_contents { font-size:80%; }\nth { background-color:#e0e0e0; font-size:80%; }\ntable.result tr:nth-child(even) { background-color:#f0f0f0; font-size:80%; }\ntable.result tr:nth-child(odd) { background-color:#ffffff; font-size:80%; }\ntr.invisible { display:none; }\n";
        String accountsListCssPrint = ".noprint { display:none; }";
        HtmlContext html = new HtmlContext();
        html.addJavaScriptLib("jQuery");
        String jsControl = "function switchInvisible()\n{\n\tvar newStatus = document.forms['form'].elements['view'].selectedIndex;\n\tswitch(newStatus)\n\t{\n\t\tcase 0: $(\".invisible\").each(function(){$(this).show();this.style.textDecoration=\"none\";});\n\t\t        break;\n\t\tcase 1: $(\".invisible\").each(function(){$(this).show();this.style.textDecoration=\"line-through\";});\n\t\t        break;\n\t\tcase 2: $(\".invisible\").each(function(){$(this).hide();this.style.textDecoration=\"none\";});\n\t\t        break;\n\t}\n}\n";
        String htmlControl = "<select id=\"view\" onChange=\"switchInvisible();\">\n<option>" + TextPool.getString("htmlTextInvisibleAccountsAreNormal") + "</option>\n" + "<option>" + TextPool.getString("htmlTextInvisibleAccountsAreStroke") + "</option>\n" + "<option>" + TextPool.getString("htmlTextInvisibleAccountsAreInvisible") + "</option>\n" + "</select>\n";
        html.addJavaScriptLib("AccountsListScript", jsControl);
        html.setTitle(TextPool.getString("htmlTitleAccountsList"));
        html.addStyleSheet(null, accountsListCss);
        html.addStyleSheet("print", accountsListCssPrint);
        html.addElement("h1", null, null, null, TextPool.getString("htmlTitleAccountsList"));
        html.addElement(DataCenter.getInstance().createGeneralDataHtmlTable());
        html.addLineBreak();
        html.addElement("form", "form", "noprint", null, htmlControl);
        String[] COLUMNS_ACCOUNT = TextPool.getArray("COLUMNS_ACCOUNT");
        HtmlTable table = new HtmlTable(html, true);
        int i = 0;
        while (i < COLUMNS_ACCOUNT.length - 1) {
            table.setContents(i, 0, COLUMNS_ACCOUNT[i]);
            table.setHeadline(i, 0, true);
            ++i;
        }
        table.setRowAsHeader(0, true);
        table.setBorder("1");
        table.addCssClass("result");
        int y = 1;
        for (Account account : this.accountList) {
            if (!account.isVisible()) {
                table.setRowCssClass(y, "invisible");
            }
            table.setContents(0, y, Integer.toString(account.getAccountNumber()));
            table.setCssStyle(0, y, "text-align:right;");
            table.setContents(1, y, account.getAccountName());
            String accountType = null;
            if (account.isIncomeAccount() && account.isTaxAccount()) {
                accountType = TextPool.getString("accountTypeIncomeTax");
            }
            if (account.isIncomeAccount() && !account.isTaxAccount()) {
                accountType = TextPool.getString("accountTypeIncome");
            }
            if (account.isSpendingsAccount() && account.isTaxAccount()) {
                accountType = TextPool.getString("accountTypeSpendingTax");
            }
            if (account.isSpendingsAccount() && !account.isTaxAccount()) {
                accountType = TextPool.getString("accountTypeSpending");
            }
            table.setContents(2, y, accountType);
            table.setCssStyle(2, y, "text-align:center;");
            ++y;
        }
        html.addElement(table);
        this.putData(RESULT_HTML_DATA, html);
        return html.toStringBuffer();
    }
}

