/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.undo;

import de.uwemock.datetools.Date;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import javax.swing.undo.AbstractUndoableEdit;

public class SetReceiptPaidEdit
extends AbstractUndoableEdit {
    private AbstractReceipt receipt;
    private Date oldDate;
    private Date newDate;

    public SetReceiptPaidEdit(AbstractReceipt receipt, Date oldDate, Date newDate) {
        this.receipt = receipt;
        this.oldDate = oldDate;
        this.newDate = newDate;
    }

    @Override
    public String getPresentationName() {
        return String.format(TextPool.getString("undoSetReceiptPaid"), this.receipt.getNumber());
    }

    @Override
    public void undo() {
        super.undo();
        ReceiptGroupManager.getInstance().remove(this.receipt);
        this.receipt.setPaid(false);
        this.receipt.setDate(this.oldDate);
        ReceiptGroupManager.getInstance().add(this.receipt);
        this.receipt.setChanged();
        this.receipt.notifyObservers();
    }

    @Override
    public void redo() {
        super.redo();
        ReceiptGroupManager.getInstance().remove(this.receipt);
        this.receipt.setPaid(true);
        this.receipt.setDate(this.newDate);
        ReceiptGroupManager.getInstance().add(this.receipt);
        this.receipt.setChanged();
        this.receipt.notifyObservers();
    }
}

