/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.undo;

import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import javax.swing.undo.AbstractUndoableEdit;

public class RemoveReceiptEdit
extends AbstractUndoableEdit {
    private AbstractReceipt receipt;
    private boolean receiptHasHadAttachments;
    private boolean receiptWasInDepreciationPool;

    public RemoveReceiptEdit(AbstractReceipt receipt, boolean receiptWasInDepreciationPool, boolean receiptHasHadAttachments) {
        this.receipt = receipt;
        this.receiptHasHadAttachments = receiptHasHadAttachments;
        this.receiptWasInDepreciationPool = receiptWasInDepreciationPool;
    }

    @Override
    public boolean canUndo() {
        return !this.receiptHasHadAttachments;
    }

    @Override
    public boolean canRedo() {
        return !this.receiptHasHadAttachments;
    }

    @Override
    public String getPresentationName() {
        return String.format(TextPool.getString("undoRemoveReceipt"), this.receipt.getNumber());
    }

    @Override
    public void undo() {
        super.undo();
        if (this.receiptWasInDepreciationPool) {
            PoolManager.getInstance().add(this.receipt);
        } else {
            ReceiptGroupManager.getInstance().add(this.receipt);
        }
        ReceiptGroupManager.getInstance().recountReceiptNumber();
    }

    @Override
    public void redo() {
        super.redo();
        if (this.receiptWasInDepreciationPool) {
            PoolManager.getInstance().remove(this.receipt);
        } else {
            ReceiptGroupManager.getInstance().remove(this.receipt);
        }
        ReceiptGroupManager.getInstance().recountReceiptNumber();
    }
}

