/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.undo;

import de.uwemock.eur.depreciation.ExtraDepreciation;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import javax.swing.undo.AbstractUndoableEdit;

public class RemoveExtraDepreciationEdit
extends AbstractUndoableEdit {
    private AbstractReceipt receipt;
    private ExtraDepreciation extraDepreciation;

    public RemoveExtraDepreciationEdit(AbstractReceipt receipt, ExtraDepreciation extraDepreciation) {
        this.receipt = receipt;
        this.extraDepreciation = extraDepreciation;
    }

    @Override
    public String getPresentationName() {
        return String.format(TextPool.getString("undoRemoveExtraDepreciation"), this.receipt.getNumber());
    }

    @Override
    public void undo() {
        super.undo();
        this.receipt.getDepreciationStrategy().setExtraDepreciation(this.extraDepreciation);
        this.receipt.setChanged();
        this.receipt.notifyObservers();
    }

    @Override
    public void redo() {
        super.redo();
        this.receipt.getDepreciationStrategy().setExtraDepreciation(null);
        this.receipt.setChanged();
        this.receipt.notifyObservers();
    }
}

