/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.undo;

import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import javax.swing.undo.AbstractUndoableEdit;

public class MoveReceiptFromPoolEdit
extends AbstractUndoableEdit {
    private AbstractReceipt receipt;

    public MoveReceiptFromPoolEdit(AbstractReceipt receipt) {
        this.receipt = receipt;
    }

    @Override
    public String getPresentationName() {
        return String.format(TextPool.getString("undoMoveReceiptFromPool"), this.receipt.getNumber());
    }

    @Override
    public void undo() {
        super.undo();
        ReceiptGroupManager.getInstance().moveReceiptToPool(this.receipt);
    }

    @Override
    public void redo() {
        super.redo();
        ReceiptGroupManager.getInstance().removeReceiptFromPool(this.receipt);
    }
}

