/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.undo;

import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.gui.undo.UndoListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class JesUndoManager
extends UndoManager {
    private static JesUndoManager instance = null;
    private List<UndoListener> listener = new ArrayList<UndoListener>();

    public static JesUndoManager getInstance() {
        if (instance == null) {
            instance = new JesUndoManager();
        }
        return instance;
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (super.addEdit(anEdit)) {
            this.notifyListeners();
            return true;
        }
        return false;
    }

    @Override
    public void undo() {
        super.undo();
        DataCenter.getInstance().setDataChanged();
        this.notifyListeners();
    }

    @Override
    public void redo() {
        super.redo();
        this.notifyListeners();
    }

    @Override
    public void discardAllEdits() {
        super.discardAllEdits();
        this.notifyListeners();
    }

    public void addUndoListener(UndoListener l) {
        this.listener.add(l);
    }

    public void removeUndoListener(UndoListener l) {
        this.listener.remove(l);
    }

    public void notifyListeners() {
        for (UndoListener l : this.listener) {
            l.undoUpdated(this);
        }
    }
}

