/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.undo;

import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import javax.swing.undo.AbstractUndoableEdit;

public class EditReceiptEdit
extends AbstractUndoableEdit {
    private AbstractReceipt oldReceipt;
    private AbstractReceipt newReceipt;
    private ReceiptGroupManager receiptOwner;

    public EditReceiptEdit(AbstractReceipt oldReceipt, AbstractReceipt newReceipt, ReceiptGroupManager owner) {
        this.oldReceipt = oldReceipt;
        this.newReceipt = newReceipt;
        this.receiptOwner = owner;
    }

    protected ReceiptGroupManager getReceiptOwner() {
        return this.receiptOwner;
    }

    protected AbstractReceipt getOldReceipt() {
        return this.oldReceipt;
    }

    @Override
    public String getPresentationName() {
        return String.format(TextPool.getString("undoEditReceipt"), this.oldReceipt.getNumber());
    }

    @Override
    public void undo() {
        super.undo();
        this.receiptOwner.replace(this.newReceipt, this.oldReceipt);
        this.oldReceipt.setChanged();
        this.oldReceipt.notifyObservers();
    }

    @Override
    public void redo() {
        super.redo();
        this.receiptOwner.replace(this.oldReceipt, this.newReceipt);
        this.newReceipt.setChanged();
        this.newReceipt.notifyObservers();
    }
}

