/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.undo;

import de.uwemock.eur.depreciation.ExtraDepreciation;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import javax.swing.undo.AbstractUndoableEdit;

public class EditExtraDepreciationEdit
extends AbstractUndoableEdit {
    private AbstractReceipt receipt;
    private ExtraDepreciation oldExtraDepreciation;
    private ExtraDepreciation newExtraDepreciation;

    public EditExtraDepreciationEdit(AbstractReceipt receipt, ExtraDepreciation oldExtraDepreciation, ExtraDepreciation newExtraDepreciation) {
        this.receipt = receipt;
        this.oldExtraDepreciation = oldExtraDepreciation;
        this.newExtraDepreciation = newExtraDepreciation;
    }

    @Override
    public String getPresentationName() {
        return String.format(TextPool.getString("undoEditExtraDepreciation"), this.receipt.getNumber());
    }

    @Override
    public void undo() {
        super.undo();
        this.receipt.getDepreciationStrategy().setExtraDepreciation(this.oldExtraDepreciation);
        this.receipt.setChanged();
        this.receipt.notifyObservers();
    }

    @Override
    public void redo() {
        super.redo();
        this.receipt.getDepreciationStrategy().setExtraDepreciation(this.newExtraDepreciation);
        this.receipt.setChanged();
        this.receipt.notifyObservers();
    }
}

