/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.undo;

import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import javax.swing.undo.AbstractUndoableEdit;

public class EditDepreciationEdit
extends AbstractUndoableEdit {
    private AbstractReceipt receipt;
    private DepreciationStrategy oldStrategy;
    private DepreciationStrategy newStrategy;

    public EditDepreciationEdit(AbstractReceipt receipt, DepreciationStrategy oldStrategy, DepreciationStrategy newStrategy) {
        this.receipt = receipt;
        this.oldStrategy = oldStrategy;
        this.newStrategy = newStrategy;
    }

    @Override
    public String getPresentationName() {
        return String.format(TextPool.getString("undoEditDepreciation"), this.receipt.getNumber());
    }

    @Override
    public void undo() {
        super.undo();
        this.receipt.setDepreciationStrategy(this.oldStrategy);
        this.receipt.setChanged();
        this.receipt.notifyObservers();
    }

    @Override
    public void redo() {
        super.redo();
        this.receipt.setDepreciationStrategy(this.newStrategy);
        this.receipt.setChanged();
        this.receipt.notifyObservers();
    }
}

