/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.undo;

import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.data.FileContext;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.tools.LoggingManager;
import java.io.IOException;
import javax.swing.undo.AbstractUndoableEdit;

public class AddReceiptEdit
extends AbstractUndoableEdit {
    private FileContext fileContext;
    private AbstractReceipt receipt;
    private boolean originalReceiptHadAttachments;
    private boolean originalReceiptWasInPool;

    public AddReceiptEdit(FileContext fileContext, AbstractReceipt receipt) {
        this.fileContext = fileContext;
        this.receipt = receipt;
        this.originalReceiptHadAttachments = receipt.hasAttachments();
        this.originalReceiptWasInPool = PoolManager.getInstance().contains(receipt);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return !this.originalReceiptHadAttachments;
    }

    @Override
    public String getPresentationName() {
        return String.format(TextPool.getString("undoAddReceipt"), this.receipt.getNumber());
    }

    @Override
    public void undo() {
        super.undo();
        if (this.receipt.hasAttachments()) {
            for (Attachment a : this.receipt.getAttachments()) {
                this.receipt.deleteAttachment(a);
                try {
                    this.fileContext.deleteAttachment(a);
                }
                catch (IOException e) {
                    LoggingManager.logException(this.getClass(), e);
                }
            }
        }
        if (this.originalReceiptWasInPool) {
            PoolManager.getInstance().remove(this.receipt);
        } else {
            ReceiptGroupManager.getInstance().remove(this.receipt);
        }
        ReceiptGroupManager.getInstance().recountReceiptNumber();
    }

    @Override
    public void redo() {
        super.redo();
        if (this.originalReceiptWasInPool) {
            PoolManager.getInstance().add(this.receipt);
        } else {
            ReceiptGroupManager.getInstance().add(this.receipt);
        }
        ReceiptGroupManager.getInstance().recountReceiptNumber();
    }
}

