/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.undo;

import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import javax.swing.undo.AbstractUndoableEdit;

public class AddDepreciationEdit
extends AbstractUndoableEdit {
    private AbstractReceipt receipt;
    private DepreciationStrategy depreciationStrategy;

    public AddDepreciationEdit(AbstractReceipt receipt, DepreciationStrategy depreciationStrategy) {
        this.receipt = receipt;
        this.depreciationStrategy = depreciationStrategy;
    }

    @Override
    public String getPresentationName() {
        return String.format(TextPool.getString("undoAddDepreciation"), this.receipt.getNumber());
    }

    @Override
    public void undo() {
        super.undo();
        this.receipt.setDepreciationStrategy(null);
        this.receipt.setChanged();
        this.receipt.notifyObservers();
    }

    @Override
    public void redo() {
        super.redo();
        this.receipt.setDepreciationStrategy(this.depreciationStrategy);
        this.receipt.setChanged();
        this.receipt.notifyObservers();
    }
}

