/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.undo;

import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.data.FileContext;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.actions.attachment.AttachmentContainer;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.tools.LoggingManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.undo.AbstractUndoableEdit;

public class AddAttachmentsEdit
extends AbstractUndoableEdit {
    private AttachmentContainer container;
    private Collection<Attachment> attachmentsAdded;
    private FileContext fileContext;

    public AddAttachmentsEdit(AttachmentContainer receipt, Collection<Attachment> attachmentsAdded, FileContext fileContext) {
        this.container = receipt;
        this.attachmentsAdded = attachmentsAdded;
        this.fileContext = fileContext;
    }

    public AddAttachmentsEdit(AbstractReceipt receipt, Attachment[] attachmentsAdded, FileContext fileContext) {
        this.container = receipt;
        this.fileContext = fileContext;
        this.attachmentsAdded = new ArrayList<Attachment>(attachmentsAdded.length);
        Attachment[] attachmentArray = attachmentsAdded;
        int n = attachmentsAdded.length;
        int n2 = 0;
        while (n2 < n) {
            Attachment a = attachmentArray[n2];
            this.attachmentsAdded.add(a);
            ++n2;
        }
    }

    @Override
    public String getPresentationName() {
        return TextPool.getString("undoAddAttachments");
    }

    @Override
    public void undo() {
        super.undo();
        for (Attachment a : this.attachmentsAdded) {
            try {
                this.container.deleteAttachment(a);
                this.fileContext.deleteAttachment(a);
            }
            catch (IOException ex) {
                LoggingManager.logException(this.getClass(), ex);
            }
        }
    }

    @Override
    public boolean canRedo() {
        return false;
    }

    @Override
    public void die() {
        this.attachmentsAdded = null;
        this.fileContext = null;
    }
}

