/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.search;

import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.Tax;
import de.uwemock.eur.data.gui.TaxComboBox;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.search.AbstractReceiptSearcher;
import de.uwemock.eur.receipt.Payment;
import de.uwemock.eur.receipt.Receipt;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.JLabel;

public class TaxReceiptSearcher
extends AbstractReceiptSearcher {
    private TaxComboBox taxList;
    private String taxKey;

    public TaxReceiptSearcher() {
        this.createComponentTree();
        this.connectListeners();
    }

    private void createComponentTree() {
        this.taxList = new TaxComboBox(DataCenter.getInstance().getTaxList());
        this.setLayout(new FlowLayout(0, 10, 0));
        this.add(new JLabel("ist gleich"));
        this.add(this.taxList);
    }

    private void connectListeners() {
        this.taxList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                Tax t = TaxReceiptSearcher.this.taxList.getSelectedTax();
                TaxReceiptSearcher.this.taxKey = t.getTaxKey();
            }
        });
    }

    @Override
    public boolean selectReceipt(Receipt r) {
        Collection<Payment> payments = r.getAllPayments();
        for (Payment p : payments) {
            if (!p.getTaxKey().equals(this.taxKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(TextPool.getString("labelTax")) + " " + "ist gleich" + " " + this.taxKey;
    }
}

