/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.search;

import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.search.AbstractReceiptSearcher;
import de.uwemock.eur.receipt.Receipt;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class ReceiptIDReceiptSearcher
extends AbstractReceiptSearcher {
    private JTextField inputSearchText;
    private String searchText;

    public ReceiptIDReceiptSearcher() {
        this.createComponentTree();
        this.connectListeners();
    }

    private void createComponentTree() {
        this.inputSearchText = new JTextField(20);
        this.setLayout(new FlowLayout(0, 10, 0));
        this.add(new JLabel("enth\u00e4lt"));
        this.add(this.inputSearchText);
    }

    private void connectListeners() {
        this.inputSearchText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.getAmount(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.getAmount(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.getAmount(e);
            }

            private void getAmount(DocumentEvent e) {
                try {
                    ReceiptIDReceiptSearcher.this.searchText = e.getDocument().getText(0, e.getDocument().getLength()).toUpperCase();
                }
                catch (BadLocationException e1) {
                    ReceiptIDReceiptSearcher.this.searchText = null;
                }
            }
        });
    }

    @Override
    public boolean selectReceipt(Receipt r) {
        String receiptDescription = r.getId().toUpperCase();
        return receiptDescription.indexOf(this.searchText) >= 0;
    }

    @Override
    public String toString() {
        return String.valueOf(TextPool.getString("labelReceiptId")) + " " + "enth\u00e4lt" + " \"" + this.searchText + "\"";
    }
}

