/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.search;

import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.search.AbstractReceiptSearcher;
import de.uwemock.eur.receipt.Receipt;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class PaidStateReceiptSearcher
extends AbstractReceiptSearcher {
    private JComboBox desiredState;
    private boolean askingForPaidReceipts;

    public PaidStateReceiptSearcher() {
        this.createComponentTree();
        this.connectListeners();
    }

    private void createComponentTree() {
        this.desiredState = new JComboBox<String>(TextPool.getArray("SEARCH_RELATION_PAIDSTATE"));
        this.setLayout(new FlowLayout(0, 10, 0));
        this.add(new JLabel("ist gleich"));
        this.add(this.desiredState);
    }

    private void connectListeners() {
        this.desiredState.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                PaidStateReceiptSearcher.this.askingForPaidReceipts = PaidStateReceiptSearcher.this.desiredState.getSelectedIndex() > 0;
            }
        });
    }

    @Override
    public boolean selectReceipt(Receipt r) {
        return r.isPaid() == this.askingForPaidReceipts;
    }

    @Override
    public String toString() {
        return String.valueOf(TextPool.getString("labelPaidState")) + " " + "ist gleich" + " " + this.desiredState.getSelectedItem().toString();
    }
}

