/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.search;

import com.toedter.calendar.JDateChooser;
import de.uwemock.datetools.Date;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.search.AbstractReceiptSearcher;
import de.uwemock.eur.receipt.Receipt;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import javax.swing.JComboBox;

public class DateReceiptSearcher
extends AbstractReceiptSearcher {
    private JDateChooser dateChooser;
    private JComboBox selectRelation;
    private Date selectedDate;

    public DateReceiptSearcher() {
        this.createComponentTree();
        this.connectListeners();
    }

    private void createComponentTree() {
        this.selectRelation = new JComboBox<String>(TextPool.getArray("SEARCH_RELATION_DATE"));
        this.dateChooser = new JDateChooser();
        Calendar today = Calendar.getInstance();
        today.set(1, DataCenter.getInstance().getBusinessYear());
        this.dateChooser.setDate(today.getTime());
        Calendar minDate = Calendar.getInstance();
        minDate.set(DataCenter.getInstance().getBusinessYear(), 0, 1);
        Calendar maxDate = Calendar.getInstance();
        maxDate.set(DataCenter.getInstance().getBusinessYear(), 11, 31);
        this.dateChooser.setSelectableDateRange(minDate.getTime(), maxDate.getTime());
        this.dateChooser.setDateFormatString(SettingsManager.getInstance().getDateFormat().getFormatString());
        this.setLayout(new FlowLayout(0, 10, 0));
        this.add(this.selectRelation);
        this.add(this.dateChooser);
    }

    private void connectListeners() {
        this.dateChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                Calendar c = DateReceiptSearcher.this.dateChooser.getCalendar();
                if (c != null) {
                    DateReceiptSearcher.this.selectedDate = new Date(c);
                }
            }
        });
    }

    @Override
    public boolean selectReceipt(Receipt r) {
        if (this.selectedDate == null) {
            return true;
        }
        Date receiptDate = r.getDate();
        switch (this.selectRelation.getSelectedIndex()) {
            case 0: {
                return receiptDate.compareTo(this.selectedDate) >= 0;
            }
            case 1: {
                return receiptDate.compareTo(this.selectedDate) <= 0;
            }
            case 2: {
                return receiptDate.compareTo(this.selectedDate) == 0;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(TextPool.getString("labelDate")) + " " + TextPool.getArray("SEARCH_RELATION_DATE")[this.selectRelation.getSelectedIndex()] + " " + this.selectedDate.toString();
    }
}

