/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.search;

import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.search.AbstractReceiptSearcher;
import de.uwemock.eur.gui.search.AccountReceiptSearcher;
import de.uwemock.eur.gui.search.AmountReceiptSearcher;
import de.uwemock.eur.gui.search.DateReceiptSearcher;
import de.uwemock.eur.gui.search.DescriptionReceiptSearcher;
import de.uwemock.eur.gui.search.PaidStateReceiptSearcher;
import de.uwemock.eur.gui.search.ReceiptIDReceiptSearcher;
import de.uwemock.eur.gui.search.TaxReceiptSearcher;
import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class BaseReceiptSearcher
extends JPanel {
    private JComboBox selectSearchOption;
    private AbstractReceiptSearcher receiptSearcher;

    public BaseReceiptSearcher() {
        this.createComponentTree();
        this.connectListeners();
    }

    private void createComponentTree() {
        this.setLayout(new BorderLayout(10, 0));
        this.selectSearchOption = new JComboBox<String>(TextPool.getArray("SEARCH_OPTIONS"));
        this.searchOptionSelected();
        this.add("West", this.selectSearchOption);
    }

    private void connectListeners() {
        this.selectSearchOption.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                BaseReceiptSearcher.this.searchOptionSelected();
            }
        });
    }

    private void searchOptionSelected() {
        if (this.receiptSearcher != null) {
            this.remove(this.receiptSearcher);
        }
        switch (this.selectSearchOption.getSelectedIndex()) {
            case 0: {
                this.receiptSearcher = new DateReceiptSearcher();
                break;
            }
            case 1: {
                this.receiptSearcher = new AccountReceiptSearcher();
                break;
            }
            case 2: {
                this.receiptSearcher = new ReceiptIDReceiptSearcher();
                break;
            }
            case 3: {
                this.receiptSearcher = new DescriptionReceiptSearcher();
                break;
            }
            case 4: {
                this.receiptSearcher = new PaidStateReceiptSearcher();
                break;
            }
            case 5: {
                this.receiptSearcher = new AmountReceiptSearcher();
                break;
            }
            case 6: {
                this.receiptSearcher = new TaxReceiptSearcher();
            }
        }
        this.add("Center", this.receiptSearcher);
        this.revalidate();
        this.repaint();
    }

    public AbstractReceiptSearcher getSearcher() {
        return this.receiptSearcher;
    }

    @Override
    public String toString() {
        if (this.receiptSearcher != null) {
            return this.receiptSearcher.toString();
        }
        return "";
    }
}

