/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.search;

import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.LocalizationManager;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.search.AbstractReceiptSearcher;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.guitools.validators.FloatValidator;
import de.uwemock.guitools.validators.ValidatorHook;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AmountReceiptSearcher
extends AbstractReceiptSearcher {
    private JComboBox inputInclExclTax;
    private JComboBox inputLtGtEq;
    private JTextField inputAmount;
    private int receiptInfoID = 5;
    private int selectedLtGtEq;
    private BigDecimal amountEntered;

    public AmountReceiptSearcher() {
        this.createComponentTree();
        this.connectListeners();
    }

    private void createComponentTree() {
        this.inputAmount = new JTextField(12);
        this.inputAmount.setHorizontalAlignment(4);
        new ValidatorHook(this.inputAmount, new FloatValidator(2, 2));
        this.inputInclExclTax = new JComboBox<String>(TextPool.getArray("SEARCH_RELATION_AMOUNT_INCL_EXCL"));
        this.inputLtGtEq = new JComboBox<String>(TextPool.getArray("SEARCH_RELATION_AMOUNT_LT_GT_EQ"));
        this.setLayout(new FlowLayout(0, 10, 0));
        this.add(this.inputInclExclTax);
        this.add(this.inputLtGtEq);
        this.add(this.inputAmount);
        this.add(new JLabel(DataCenter.getInstance().getCurrency()));
    }

    private void connectListeners() {
        this.inputInclExclTax.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                switch (AmountReceiptSearcher.this.inputInclExclTax.getSelectedIndex()) {
                    case 0: {
                        AmountReceiptSearcher.this.receiptInfoID = 5;
                        break;
                    }
                    case 1: {
                        AmountReceiptSearcher.this.receiptInfoID = 6;
                    }
                }
            }
        });
        this.inputLtGtEq.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                AmountReceiptSearcher.this.selectedLtGtEq = AmountReceiptSearcher.this.inputLtGtEq.getSelectedIndex();
            }
        });
        this.inputAmount.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.getAmount(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.getAmount(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.getAmount(e);
            }

            private void getAmount(DocumentEvent e) {
                AmountReceiptSearcher.this.amountEntered = null;
                try {
                    AmountReceiptSearcher.this.amountEntered = new BigDecimal(e.getDocument().getText(0, e.getDocument().getLength()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public boolean selectReceipt(Receipt r) {
        if (this.amountEntered == null) {
            return false;
        }
        BigDecimal receiptAmount = (BigDecimal)r.getReceiptInfo(this.receiptInfoID);
        if (receiptAmount == null) {
            return false;
        }
        switch (this.selectedLtGtEq) {
            case 0: {
                return receiptAmount.compareTo(this.amountEntered) < 0;
            }
            case 1: {
                return receiptAmount.compareTo(this.amountEntered) > 0;
            }
            case 2: {
                return receiptAmount.compareTo(this.amountEntered) == 0;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(TextPool.getString("labelAmount")) + " " + TextPool.getArray("SEARCH_RELATION_AMOUNT_INCL_EXCL")[this.inputInclExclTax.getSelectedIndex()] + " " + TextPool.getArray("SEARCH_RELATION_AMOUNT_LT_GT_EQ")[this.selectedLtGtEq] + " " + LocalizationManager.amountToCurrencyString(this.amountEntered);
    }
}

