/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.search;

import de.uwemock.csvtools.CsvTable;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.search.AbstractReceiptSearcher;
import de.uwemock.eur.kernels.HtmlContentsHelper;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.ReceiptGroup;
import de.uwemock.eur.receipt.builder.CsvReceiptListBuilder;
import de.uwemock.eur.receipt.builder.ReceiptTableBuilder;
import de.uwemock.eur.receipt.builder.ReceiptWalker;
import de.uwemock.htmltools.HtmlContainer;
import de.uwemock.htmltools.HtmlContext;
import de.uwemock.htmltools.HtmlLink;
import de.uwemock.htmltools.HtmlText;
import de.uwemock.tools.LoggingManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;

public class ActionPrintSearchResult
extends AbstractAction {
    private Collection<AbstractReceipt> searchResult = new LinkedList<AbstractReceipt>();
    private StringBuilder searchText;

    public ActionPrintSearchResult() {
        super(TextPool.getString("buttonPrintSearchResult"));
        this.setEnabled(false);
        this.searchText = new StringBuilder();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        HtmlContext html;
        block14: {
            String journalCss = "body { font-family:Verdana,Arial,Helvetia,sans-serif; }\nh1 { }\nh3 { }\ntd.general_label { font-weight:bold; font-size:80%; }\ntd.general_contents { font-size:80%; }\nth { background-color:#e0e0e0; font-size:80%; }\ntable.result tr:nth-child(even) { background-color:#f0f0f0; font-size:80%; }\ntable.result tr:nth-child(odd) { background-color:#ffffff; font-size:80%; }\n.deleted { text-decoration:line-through; }\n.totalPaid { display:none; }\n.totalUnpaid { display:none; }\n.minitable { font-size:90%; }\ntd.leftcell { border-right:solid 1px black; }\ntd.rightcell { }\ntd.midcell { border-right:solid 1px black; }\n.amount { font-family:monospace; white-space:nowrap; }";
            String journalCssPrint = ".noprint { display:none; }";
            html = new HtmlContext();
            html.setTitle(TextPool.getString("htmlTitleSearchResult"));
            html.addStyleSheet(null, journalCss);
            html.addStyleSheet("print", journalCssPrint);
            html.addElement("h1", null, null, null, TextPool.getString("htmlTitleSearchResult"));
            html.addElement("p", null, null, null, TextPool.getString("htmlTextSearchString"));
            html.addElement("ul", null, null, null, this.searchText.toString());
            html.addElement(DataCenter.getInstance().createGeneralDataHtmlTable());
            html.addLineBreak();
            HtmlContentsHelper.addSwitchDeleted(html);
            HtmlContentsHelper.addSwitchUnpaid(html);
            html.addLineBreak();
            ReceiptWalker walker = new ReceiptWalker(this.searchResult);
            ReceiptTableBuilder htmlBuilder = new ReceiptTableBuilder(html, null);
            CsvReceiptListBuilder csvBuilder = new CsvReceiptListBuilder(null);
            walker.addReceiptProcessor(htmlBuilder);
            walker.addReceiptProcessor(csvBuilder);
            walker.run();
            html.addElement(htmlBuilder.getResult());
            CsvTable csvTable = csvBuilder.getResult();
            html.addElement(DataCenter.getInstance().createGeneralInfoHtml());
            Calendar c = Calendar.getInstance();
            OutputStreamWriter writer = null;
            try {
                try {
                    File file = File.createTempFile(String.valueOf(String.format("%4d-%02d-%02d", c.get(1), c.get(2) + 1, c.get(5))) + "_eur_receipts", ".csv");
                    file.deleteOnExit();
                    writer = new FileWriter(file);
                    writer.write(csvTable.toCsvString().toString());
                    writer.flush();
                    HtmlLink link = new HtmlLink(file.getName());
                    link.addHtmlElement(new HtmlText(TextPool.getString("htmlTextLinkToCsv")));
                    HtmlContainer linkContainer = new HtmlContainer("p");
                    linkContainer.addCssClass("noprint");
                    linkContainer.addHtmlElement(link);
                    html.addElement(linkContainer);
                }
                catch (IOException e1) {
                    LoggingManager.logException(this.getClass(), e1);
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e2) {
                            LoggingManager.logException(this.getClass(), e2);
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        LoggingManager.logException(this.getClass(), e2);
                    }
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e2) {
                    LoggingManager.logException(this.getClass(), e2);
                }
            }
        }
        DataCenter.getInstance().showHTML(html.toStringBuffer());
    }

    public void setSearchText(List<AbstractReceiptSearcher> searchers) {
        this.searchText.setLength(0);
        if (searchers == null || searchers.size() == 0) {
            this.setEnabled(false);
            return;
        }
        for (AbstractReceiptSearcher searcher : searchers) {
            this.searchText.append("<li>");
            this.searchText.append(searcher.toString());
            this.searchText.append("</li>");
        }
        this.setEnabled();
    }

    public void setSearchResult(ReceiptGroup receiptGroup) {
        this.searchResult.clear();
        this.searchResult.addAll(receiptGroup.getReceiptList());
        this.setEnabled();
    }

    private void setEnabled() {
        this.setEnabled(this.searchText.length() > 0 && this.searchResult != null);
    }
}

