/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.search;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.gui.AccountComboBox;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.search.AbstractReceiptSearcher;
import de.uwemock.eur.receipt.Receipt;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.JLabel;

public class AccountReceiptSearcher
extends AbstractReceiptSearcher {
    private AccountComboBox accountList;
    private int account;

    public AccountReceiptSearcher() {
        this.createComponentTree();
        this.connectListeners();
        this.setSelectedAccount();
    }

    private void createComponentTree() {
        this.accountList = new AccountComboBox(DataCenter.getInstance().getAccountList());
        this.setLayout(new FlowLayout(0, 10, 0));
        this.add(new JLabel("ist gleich"));
        this.add(this.accountList);
    }

    private void connectListeners() {
        this.accountList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                AccountReceiptSearcher.this.setSelectedAccount();
            }
        });
    }

    private void setSelectedAccount() {
        Account a = this.accountList.getSelectedAccount();
        this.account = a.getAccountNumber();
    }

    @Override
    public boolean selectReceipt(Receipt r) {
        Collection<Integer> accounts = r.getAllAccountNumbers();
        for (Integer nr : accounts) {
            if (nr != this.account) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(TextPool.getString("labelAccount")) + " " + "ist gleich" + " " + this.accountList.getSelectedAccount().toString();
    }
}

