/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions.attachment;

import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.data.DirectoryManager;
import de.uwemock.eur.data.FileContext;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.gui.JesFileChooser;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.actions.attachment.AttachmentAction;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;

public class AttachmentSaveAsAction
extends AttachmentAction {
    private Frame parent;
    private FileContext context;

    public AttachmentSaveAsAction(Frame parent, FileContext context, Attachment attachment) {
        super(TextPool.getString("menuAttachmentSaveAs"), attachment);
        this.parent = parent;
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JesFileChooser chooser = new JesFileChooser();
        chooser.setSelectedFile(new File(String.valueOf(SettingsManager.getInstance().getLastDirectoryUsed()) + DirectoryManager.fileSeparator + this.getAttachment().getFilename()));
        int res = chooser.showSaveDialog(this.parent);
        if (res == 0) {
            String filename = chooser.getSelectedFile().getAbsolutePath();
            try {
                this.getAttachment().saveAs(this.context, filename);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgWriteError"), TextPool.getString("titleErrorMessage"), 0);
            }
        }
    }
}

