/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions.attachment;

import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.data.FileContext;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.actions.attachment.AttachmentAction;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;

public class AttachmentOpenAction
extends AttachmentAction {
    private Frame parent;
    private FileContext context;

    public AttachmentOpenAction(Frame parent, FileContext context, Attachment attachment) {
        super(TextPool.getString("menuAttachmentOpen"), attachment);
        this.parent = parent;
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String filename = this.getAttachment().getFilename();
        try {
            int lastDot = filename.lastIndexOf(46);
            String suffix = lastDot >= 0 ? filename.substring(lastDot) : "";
            File tempFile = File.createTempFile("jes_attachment_", suffix);
            tempFile.deleteOnExit();
            this.getAttachment().saveAs(this.context, tempFile.getAbsolutePath());
            Desktop.getDesktop().open(tempFile);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgCouldNotOpenAttachment"), TextPool.getString("titleErrorMessage"), 0);
            e.printStackTrace();
        }
    }
}

