/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions.attachment;

import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.data.FileContext;
import de.uwemock.eur.gui.JesIcons;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.actions.attachment.AttachmentAddAction;
import de.uwemock.eur.gui.actions.attachment.AttachmentCheckAction;
import de.uwemock.eur.gui.actions.attachment.AttachmentDeleteAction;
import de.uwemock.eur.gui.actions.attachment.AttachmentDeleteAllAction;
import de.uwemock.eur.gui.actions.attachment.AttachmentOpenAction;
import de.uwemock.eur.gui.actions.attachment.AttachmentSaveAsAction;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.guitools.FileTypeIconProvider;
import de.uwemock.guitools.MenuScroller;
import java.awt.Frame;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenu;

public class AttachmentMenu
extends JMenu {
    public AttachmentMenu(Frame parent, FileContext context, AbstractReceipt attachmentContainer, boolean allowAddAttachment) {
        this(parent, context, attachmentContainer, allowAddAttachment, true);
    }

    public AttachmentMenu(Frame parent, FileContext context, AbstractReceipt attachmentContainer, boolean allowAddAttachment, boolean allowEdit) {
        super(TextPool.getString("menuAttachment"));
        this.setIcon(JesIcons.iconAttachment);
        if (allowEdit && allowAddAttachment) {
            this.add(new AttachmentAddAction(parent, attachmentContainer));
        }
        List<Attachment> attachments = attachmentContainer.getAttachments();
        LinkedList<Attachment> attachmentsSortable = new LinkedList<Attachment>(attachments);
        Collections.sort(attachmentsSortable, new Comparator<Attachment>(){

            @Override
            public int compare(Attachment arg0, Attachment arg1) {
                return String.CASE_INSENSITIVE_ORDER.compare(arg0.getFilename(), arg1.getFilename());
            }
        });
        if (allowEdit && attachmentsSortable.size() > 0) {
            this.add(new AttachmentDeleteAllAction(parent, context, attachmentContainer));
        }
        if (allowEdit && allowAddAttachment && attachmentsSortable.size() > 0 || allowEdit && attachmentsSortable.size() > 0) {
            this.addSeparator();
        }
        for (Attachment attachment : attachmentsSortable) {
            JMenu menu = new JMenu(attachment.getFilename());
            menu.setIcon(FileTypeIconProvider.getIconForFileType(attachment.getFilename()));
            menu.add(new AttachmentOpenAction(parent, context, attachment));
            menu.add(new AttachmentSaveAsAction(parent, context, attachment));
            if (allowEdit) {
                menu.add(new AttachmentDeleteAction(parent, context, attachmentContainer, attachment));
            }
            menu.add(new AttachmentCheckAction(parent, context, attachment));
            this.add(menu);
        }
        MenuScroller.setScrollerFor(this, 15, 125, 1, 0);
    }
}

