/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions.attachment;

import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.data.FileContext;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.actions.attachment.AttachmentContainer;
import de.uwemock.tools.LoggingManager;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class AttachmentDeleteAllAction
extends AbstractAction {
    private Frame parent;
    private FileContext context;
    private AttachmentContainer attachmentContainer;

    public AttachmentDeleteAllAction(Frame parent, FileContext context, AttachmentContainer attachmentContainer) {
        super(TextPool.getString("menuAttachmentDeleteAll"));
        this.parent = parent;
        this.context = context;
        this.attachmentContainer = attachmentContainer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int res = JOptionPane.showConfirmDialog(this.parent, TextPool.getString("msgAttachmentDeleteAll"), TextPool.getString("titleAttachmentDelete"), 0);
        if (res == 0) {
            Attachment attachment = null;
            while (this.attachmentContainer.getAttachments().size() > 0) {
                try {
                    attachment = this.attachmentContainer.getAttachments().get(0);
                    this.context.deleteAttachment(attachment);
                    this.attachmentContainer.deleteAttachment(attachment);
                }
                catch (IOException ex) {
                    LoggingManager.logException(this.getClass(), ex);
                    String message = TextPool.getString("msgCouldNotDeleteAttachment");
                    if (attachment != null) {
                        message = String.format(TextPool.getString("msgCouldNotDeleteAttachmentWithName"), attachment.getFilename());
                    }
                    JOptionPane.showMessageDialog(this.parent, message, TextPool.getString("titleErrorMessage"), 0);
                }
            }
        }
    }
}

