/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions.attachment;

import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.data.FileContext;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.actions.attachment.AttachmentAction;
import de.uwemock.eur.gui.actions.attachment.AttachmentContainer;
import de.uwemock.tools.LoggingManager;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.JOptionPane;

public class AttachmentDeleteAction
extends AttachmentAction {
    private Frame parent;
    private FileContext context;
    private AttachmentContainer attachmentContainer;

    public AttachmentDeleteAction(Frame parent, FileContext context, AttachmentContainer attachmentContainer, Attachment attachment) {
        super(TextPool.getString("menuAttachmentDelete"), attachment);
        this.parent = parent;
        this.context = context;
        this.attachmentContainer = attachmentContainer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String message = String.format(TextPool.getString("msgAttachmentDelete"), this.getAttachment().getFilename());
        int res = JOptionPane.showConfirmDialog(this.parent, message, TextPool.getString("titleAttachmentDelete"), 0);
        if (res == 0) {
            try {
                this.context.deleteAttachment(this.getAttachment());
                this.attachmentContainer.deleteAttachment(this.getAttachment());
            }
            catch (IOException ex) {
                LoggingManager.logException(this.getClass(), ex);
                JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgCouldNotDeleteAttachment"), TextPool.getString("titleErrorMessage"), 0);
            }
        }
    }
}

