/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions.attachment;

import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.data.FileContext;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.actions.attachment.AttachmentAction;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class AttachmentCheckAction
extends AttachmentAction {
    private Frame parent;
    private FileContext context;

    public AttachmentCheckAction(Frame parent, FileContext context, Attachment attachment) {
        super(TextPool.getString("menuAttachmentCheck"), attachment);
        this.parent = parent;
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String originalChecksum = this.getAttachment().getOriginalChecksum();
        String currentChecksum = this.getAttachment().getCurrentChecksum(this.context);
        if ("NONE".equals(originalChecksum)) {
            JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgAttachmentHasNoOriginalChecksum"), TextPool.getString("titleErrorMessage"), 0);
            return;
        }
        if ("NONE".equals(currentChecksum)) {
            JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgAttachmentHasNoCurrentChecksum"), TextPool.getString("titleErrorMessage"), 0);
            return;
        }
        boolean checksumOk = originalChecksum.equals(currentChecksum);
        String message = String.format(checksumOk ? TextPool.getString("msgAttachmentCheckOk") : TextPool.getString("msgAttachmentCheckNotOk"), originalChecksum, currentChecksum);
        String title = checksumOk ? TextPool.getString("titleInformation") : TextPool.getString("titleErrorMessage");
        int messageType = checksumOk ? 1 : 0;
        JOptionPane.showMessageDialog(this.parent, message, title, messageType);
    }
}

