/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions.attachment;

import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.FileContext;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.actions.attachment.AttachmentAddAction;
import de.uwemock.eur.gui.actions.attachment.AttachmentContainer;
import de.uwemock.eur.gui.undo.AddAttachmentsEdit;
import de.uwemock.eur.gui.undo.JesUndoManager;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.guitools.ProgressBarForRunnable;
import de.uwemock.guitools.RunnableResultReceiver;
import de.uwemock.tools.LoggingManager;
import de.uwemock.tools.Numbers;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AttachmentAdder {
    public static void addAttachments(Frame parent, AbstractReceipt attachmentContainer, Collection<String> filenames) {
        File[] files = new File[filenames.size()];
        int i = 0;
        for (String filename : filenames) {
            files[i++] = new File(filename);
        }
        AttachmentAdder.addAttachments(parent, attachmentContainer, files);
    }

    public static void addAttachments(Frame parent, AbstractReceipt attachmentContainer, String[] filenames) {
        File[] files = new File[filenames.length];
        int i = 0;
        while (i < filenames.length) {
            files[i] = new File(filenames[i]);
            ++i;
        }
        AttachmentAdder.addAttachments(parent, attachmentContainer, files);
    }

    public static void addAttachments(final Frame parent, final AbstractReceipt attachmentContainer, File[] files) {
        final FileContext context = DataCenter.getInstance().getFileContext();
        long maxSize = SettingsManager.getInstance().getAttachmentWarningSize();
        final ArrayList<File> filesToAdd = new ArrayList<File>(files.length);
        ArrayList<File> filesTooLarge = new ArrayList<File>(files.length);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists() && file.length() > maxSize) {
                filesTooLarge.add(file);
            } else {
                filesToAdd.add(file);
            }
            ++n2;
        }
        if (filesTooLarge.size() > 0) {
            JPanel panel = new JPanel(new GridLayout(filesTooLarge.size(), 1));
            JCheckBox[] checkBoxes = new JCheckBox[filesTooLarge.size()];
            int i = 0;
            while (i < filesTooLarge.size()) {
                File f = (File)filesTooLarge.get(i);
                checkBoxes[i] = new JCheckBox(String.valueOf(f.getAbsolutePath()) + " (" + Numbers.getMiBString(f.length(), 1) + ")");
                panel.add(checkBoxes[i]);
                ++i;
            }
            JPanel displayPanel = new JPanel(new BorderLayout(0, 10));
            displayPanel.add((Component)new JLabel(TextPool.getString("msgAttachmentsTooLarge")), "North");
            displayPanel.add((Component)panel, "South");
            JOptionPane.showMessageDialog(parent, displayPanel, TextPool.getString("titleAttachmentsTooLarge"), 3);
            int i2 = 0;
            while (i2 < checkBoxes.length) {
                if (checkBoxes[i2].isSelected()) {
                    filesToAdd.add((File)filesTooLarge.get(i2));
                }
                ++i2;
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Collection<Attachment> attachments = context.addAttachments(filesToAdd);
                    for (Attachment attachment : attachments) {
                        attachmentContainer.addAttachment(attachment);
                    }
                    JesUndoManager.getInstance().addEdit(new AddAttachmentsEdit((AttachmentContainer)attachmentContainer, attachments, context));
                }
                catch (IOException e) {
                    LoggingManager.logException(AttachmentAddAction.class, e);
                }
            }
        };
        RunnableResultReceiver resultReceiver = new RunnableResultReceiver(){

            @Override
            public void processResult(Object result) {
                if (filesToAdd.size() > 0) {
                    StringBuilder message = new StringBuilder();
                    message.append(TextPool.getString("msgAttachmentsNotAdded"));
                    for (File file : filesToAdd) {
                        message.append(file.getAbsolutePath());
                        message.append('\n');
                    }
                    JOptionPane.showMessageDialog(parent, message.toString(), TextPool.getString("titleAttachments"), 0);
                }
            }
        };
        if (filesToAdd.size() > 0) {
            ProgressBarForRunnable progressBar = new ProgressBarForRunnable(parent, runnable, resultReceiver);
            progressBar.setText(TextPool.getString("msgAddingAttachments"));
            progressBar.start();
        }
    }
}

