/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import com.toedter.calendar.JCalendar;
import de.uwemock.datetools.Date;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.gui.JesIcons;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.undo.JesUndoManager;
import de.uwemock.eur.gui.undo.SetReceiptPaidEdit;
import de.uwemock.eur.gui.undo.SetReceiptUnpaidEdit;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.StandardDialog;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;

public class ActionToggleReceiptUnpaidState
extends AbstractAction {
    private Frame parent;
    private AbstractReceipt receipt;

    public ActionToggleReceiptUnpaidState(Frame parent, AbstractReceipt r) {
        super(r.isPaid() ? TextPool.getString("menuPopupSetReceiptUnpaid") : TextPool.getString("menuPopupSetReceiptPaid"));
        this.putValue("SmallIcon", r.isPaid() ? JesIcons.iconNotPaid : JesIcons.iconPaid);
        this.parent = parent;
        this.receipt = r;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Date oldDate = this.receipt.getDate();
        if (!this.receipt.isPaid()) {
            EditReceiptDatePanel panel = new EditReceiptDatePanel(this.receipt);
            StandardDialog dialog = new StandardDialog(this.parent, TextPool.getString("titleSelectPaymentDate"), panel);
            dialog.setVisible(true);
            if (dialog.getResult() == 2) {
                return;
            }
            Date newDate = panel.getDate();
            ReceiptGroupManager.getInstance().remove(this.receipt);
            this.receipt.setDate(newDate);
            this.receipt.setPaid(true);
            ReceiptGroupManager.getInstance().add(this.receipt);
            JesUndoManager.getInstance().addEdit(new SetReceiptPaidEdit(this.receipt, oldDate, newDate));
        } else {
            this.receipt.setPaid(false);
            this.receipt.notifyObservers();
            JesUndoManager.getInstance().addEdit(new SetReceiptUnpaidEdit(this.receipt));
        }
    }

    class EditReceiptDatePanel
    extends AbstractStandardDialogPanel {
        private Action okAction;
        private AbstractReceipt receipt;
        private JCalendar calendar;
        private Date date;

        public EditReceiptDatePanel(AbstractReceipt receipt) {
            this.receipt = receipt;
            this.calendar = new JCalendar();
            this.calendar.setCalendar(receipt.getDate().toJavaCalendar());
            Calendar minDate = Calendar.getInstance();
            minDate.set(DataCenter.getInstance().getBusinessYear(), 0, 1);
            Calendar maxDate = Calendar.getInstance();
            maxDate.set(DataCenter.getInstance().getBusinessYear(), 11, 31);
            this.calendar.setMinSelectableDate(minDate.getTime());
            this.calendar.setMaxSelectableDate(maxDate.getTime());
            JButton dateRemains = new JButton(new AbstractAction(TextPool.getString("buttonDontChangeReceiptDate")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditReceiptDatePanel.this.calendar.setCalendar(EditReceiptDatePanel.this.receipt.getDate().toJavaCalendar());
                    EditReceiptDatePanel.this.okAction.actionPerformed(null);
                }
            });
            this.setLayout(new BorderLayout());
            this.add("Center", this.calendar);
            this.add("South", dateRemains);
        }

        @Override
        public void setOkAction(Action okAction) {
            this.okAction = okAction;
        }

        @Override
        public void saveDialogData() {
            this.date = Date.getDate(this.calendar.getCalendar());
        }

        public Date getDate() {
            return this.date;
        }
    }
}

