/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.calculation.Pod;
import de.uwemock.eur.calculation.PodFactory;
import de.uwemock.eur.calculation.PodTagFormatException;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.ProgressMonitor;

public class ActionTestCalculationPods
extends AbstractAction {
    private StringBuffer template;
    private JFrame parent;

    public ActionTestCalculationPods(JFrame parent) {
        block13: {
            super("Pods testen");
            this.template = new StringBuffer();
            this.parent = parent;
            BufferedReader b = null;
            try {
                try {
                    String line;
                    b = new BufferedReader(new FileReader("/home/uwe/work/projekte/Java_EUR/eur.html"));
                    while ((line = b.readLine()) != null) {
                        this.template.append(line);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (b == null) break block13;
                    try {
                        b.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (b != null) {
                    try {
                        b.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        List<AbstractReceipt> rl = ReceiptGroupManager.getInstance().getReceiptCollectionByTimeFrame(100);
        int count = 1;
        ProgressMonitor progressMonitor = new ProgressMonitor(this.parent, "Running a Long Task", "", 0, rl.size() + 1);
        progressMonitor.setNote("Creating pods...");
        progressMonitor.setProgress(1);
        ArrayList<Pod> pods = new ArrayList<Pod>();
        int i = 0;
        while (this.template.indexOf("<@", i) >= 0) {
            int n = this.template.indexOf("<@", i);
            int end = this.template.indexOf("@>", n);
            if (n >= 0 && end >= 0) {
                String tag = this.template.substring(n, end + 2);
                try {
                    pods.add(PodFactory.createPod(tag));
                }
                catch (PodTagFormatException e) {
                    System.out.println(e.getMessage());
                }
            }
            i = n + 1;
        }
        progressMonitor.setNote("Processing receipts...");
        for (Receipt receipt : rl) {
            boolean used = false;
            for (Pod pod : pods) {
                if (!pod.processReceipt(receipt)) continue;
                used = true;
            }
            progressMonitor.setProgress(count++);
            if (used) continue;
            System.out.println("Not used: " + receipt.getNumber() + ", Acc:" + receipt.getReceiptInfo(14));
        }
        progressMonitor.setNote("Setting values in template...");
        for (Pod pod : pods) {
            int pos = this.template.indexOf(pod.getTag());
            this.template.replace(pos, pos + pod.getTag().length(), pod.getResultString());
        }
        progressMonitor.close();
        DataCenter.getInstance().showHTML(this.template);
    }
}

