/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.data.FileContext;
import de.uwemock.eur.gui.JesIcons;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.undo.JesUndoManager;
import de.uwemock.eur.gui.undo.RemoveReceiptEdit;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.tools.LoggingManager;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class ActionRemoveReceipt
extends AbstractAction {
    private Frame parent;
    private AbstractReceipt receipt;
    private FileContext fileContext;

    public ActionRemoveReceipt(Frame parent, FileContext context, AbstractReceipt r) {
        super(TextPool.getString("menuPopupRemoveReceipt"));
        this.putValue("SmallIcon", JesIcons.iconDeletePhysically);
        this.parent = parent;
        this.fileContext = context;
        this.receipt = r;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int res = JOptionPane.showConfirmDialog(this.parent, TextPool.getString("msgConfirmRemovalOfReceipt"), TextPool.getString("titleRemovingReceipt"), 0);
        if (res == 0) {
            boolean receiptHasHadAttachments = this.receipt.hasAttachments();
            boolean receiptWasInDepreciationPool = PoolManager.getInstance().contains(this.receipt);
            if (this.receipt.hasAttachments()) {
                List<Attachment> attachments = this.receipt.getAttachments();
                for (Attachment a : attachments) {
                    try {
                        this.fileContext.deleteAttachment(a);
                    }
                    catch (IOException ex) {
                        LoggingManager.logException(this.getClass(), ex);
                    }
                }
            }
            if (PoolManager.getInstance().contains(this.receipt)) {
                PoolManager.getInstance().remove(this.receipt);
            } else {
                ReceiptGroupManager.getInstance().remove(this.receipt);
            }
            ReceiptGroupManager.getInstance().recountReceiptNumber();
            JesUndoManager.getInstance().addEdit(new RemoveReceiptEdit(this.receipt, receiptWasInDepreciationPool, receiptHasHadAttachments));
            this.receipt.notifyObservers();
            this.receipt.deleteObservers();
        }
    }
}

