/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.gui.JesIcons;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.undo.JesUndoManager;
import de.uwemock.eur.gui.undo.RemoveExtraDepreciationEdit;
import de.uwemock.eur.receipt.AbstractReceipt;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class ActionRemoveExtraDepreciation
extends AbstractAction {
    private int businessYear;
    private Frame parent;
    private AbstractReceipt receipt;

    public ActionRemoveExtraDepreciation(Frame parent, AbstractReceipt r, int businessYear) {
        super(TextPool.getString("menuPopupRemoveExtraDepreciation"));
        this.putValue("SmallIcon", JesIcons.iconDeleteDepreciation);
        this.parent = parent;
        this.receipt = r;
        this.businessYear = businessYear;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.receipt.getDate().getYear() != this.businessYear) {
            JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgCannotRemoveInheritedDepreciation"), TextPool.getString("titleInformation"), 1);
            return;
        }
        int res = JOptionPane.showConfirmDialog(this.parent, TextPool.getString("msgConfirmRemovalOfExtraDepreciation"), TextPool.getString("titleRemovingDepreciation"), 0);
        if (res == 0) {
            JesUndoManager.getInstance().addEdit(new RemoveExtraDepreciationEdit(this.receipt, this.receipt.getDepreciationStrategy().getExtraDepreciation()));
            this.receipt.getDepreciationStrategy().setExtraDepreciation(null);
            this.receipt.notifyObservers();
        }
    }
}

