/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.gui.JesIcons;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.undo.JesUndoManager;
import de.uwemock.eur.gui.undo.RemoveDepreciationEdit;
import de.uwemock.eur.receipt.AbstractReceipt;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class ActionRemoveDepreciationSettings
extends AbstractAction {
    private int businessYear;
    private Frame parent;
    private AbstractReceipt receipt;

    public ActionRemoveDepreciationSettings(Frame parent, AbstractReceipt r, int businessYear) {
        super(TextPool.getString("menuPopupRemoveDepreciation"));
        this.putValue("SmallIcon", JesIcons.iconDeleteDepreciation);
        this.parent = parent;
        this.receipt = r;
        this.businessYear = businessYear;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.receipt.getDate().getYear() != this.businessYear) {
            JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgCannotRemoveInheritedDepreciation"), TextPool.getString("titleInformation"), 1);
            return;
        }
        int res = JOptionPane.showConfirmDialog(this.parent, TextPool.getString("msgConfirmRemovalOfDepreciation"), TextPool.getString("titleRemovingDepreciation"), 0);
        if (res == 0) {
            JesUndoManager.getInstance().addEdit(new RemoveDepreciationEdit(this.receipt, this.receipt.getDepreciationStrategy()));
            this.receipt.setDepreciationStrategy(null);
            this.receipt.notifyObservers();
        }
    }
}

