/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.gui.CalculationDialog;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.kernels.KernelReceiptList;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.eur.receipt.comparators.ReceiptComparator;
import de.uwemock.guitools.AbstractToolbarAction;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;

public class ActionReceiptList
extends AbstractToolbarAction {
    private JFrame parent;

    public ActionReceiptList(JFrame parent, String resourceIconSmall, String resourceIconLarge) {
        super(TextPool.getString("menuReceiptList"), resourceIconSmall, resourceIconLarge);
        this.parent = parent;
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        CalculationDialog dialog = new CalculationDialog(this.parent, TextPool.getString("titleTimeSelectionDialog"), 30);
        dialog.setVisible(true);
        if (dialog.getResult() == 1) {
            int timeFrame = dialog.getSelectedTimeFrame();
            String timeFrameText = dialog.getSelectedTimeFrameText();
            Account[] accFilter = dialog.getSelectedAccounts();
            ReceiptComparator receiptComparator = dialog.getSortComparator();
            KernelReceiptList k = new KernelReceiptList(ReceiptGroupManager.getInstance(), PoolManager.getInstance(), timeFrame, timeFrameText, accFilter, receiptComparator, null);
            StringBuffer html = null;
            try {
                html = (StringBuffer)k.executeWork();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (html != null) {
                DataCenter.getInstance().showHTML(html);
            }
        }
        dialog.dispose();
    }
}

