/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.datetools.Date;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.gui.AttachmentSettingsPanel;
import de.uwemock.eur.gui.AutoSaveSettingsPanel;
import de.uwemock.eur.gui.BrowserSettingsPanel;
import de.uwemock.eur.gui.GeneralSettingsPanel;
import de.uwemock.eur.gui.GuiSettingsPanel;
import de.uwemock.eur.gui.LogSettingsPanel;
import de.uwemock.eur.gui.MainTablePanel;
import de.uwemock.eur.gui.ReceiptInputDialogDefaultButtonSettingsPanel;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.StandardDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.lang.ref.SoftReference;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

public class ActionProgramSettings
extends AbstractAction {
    private JFrame parent;
    private MainTablePanel mainTablePanel;
    private SoftReference<StandardDialog> dialogSoftRef;

    public ActionProgramSettings(JFrame parent) {
        super(TextPool.getString("menuSettingsProgram"));
        this.parent = parent;
    }

    public void setMainTablePanel(MainTablePanel panel) {
        this.mainTablePanel = panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Date.DateFormat oldDateFormat = SettingsManager.getInstance().getDateFormat();
        Logger logger = Logger.getLogger(this.getClass().getName());
        StandardDialog dialog = null;
        if (this.dialogSoftRef != null) {
            dialog = this.dialogSoftRef.get();
        }
        if (dialog == null) {
            logger.fine("No program settings dialog found, creating the dialog.");
            dialog = new StandardDialog((Frame)this.parent, TextPool.getString("titleProgramSettings"));
            dialog.startNewTab(TextPool.getString("titleSettingsGeneral"));
            dialog.addPanel(new GeneralSettingsPanel(this.parent));
            dialog.addPanel(new AttachmentSettingsPanel());
            dialog.addPanel(new AutoSaveSettingsPanel());
            dialog.startNewTab(TextPool.getString("titleSettingsGui"));
            dialog.addPanel(new GuiSettingsPanel(this.parent));
            dialog.addPanel(new ReceiptInputDialogDefaultButtonSettingsPanel());
            dialog.addPanel(new BrowserSettingsPanel());
            dialog.startNewTab(TextPool.getString("titleLoggingSettings"));
            dialog.addPanel(new LogSettingsPanel());
            this.dialogSoftRef = new SoftReference<StandardDialog>(dialog);
        } else {
            logger.fine("Program settings dialog found in soft reference, re-using the dialog.");
        }
        dialog.setVisible(true);
        Date.DateFormat newDateFormat = SettingsManager.getInstance().getDateFormat();
        if (oldDateFormat != newDateFormat) {
            this.mainTablePanel.repaintTables();
        }
    }
}

