/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.calculation.ActionPod;
import de.uwemock.eur.calculation.ActionPodType;
import de.uwemock.eur.calculation.Pod;
import de.uwemock.eur.calculation.PodFactory;
import de.uwemock.eur.calculation.PodTagFormatException;
import de.uwemock.eur.calculation.SimplePod;
import de.uwemock.eur.calculation.plugins.EurPlugin;
import de.uwemock.eur.calculation.plugins.PodsProcessor;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.TimeFrame;
import de.uwemock.eur.gui.TimeFrameSelectionDialog;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.eur.receipt.builder.ReceiptWalker;
import de.uwemock.guitools.AbstractToolbarAction;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class ActionProcessPlugin
extends AbstractToolbarAction {
    private Frame parent;
    private EurPlugin plugin;

    public ActionProcessPlugin(Frame parent, EurPlugin plugin, String resourceIconSmall, String resourceIconLarge) {
        super(plugin.getPluginTitle(), resourceIconSmall, resourceIconLarge);
        this.parent = parent;
        this.plugin = plugin;
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        List<Pod> pods;
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.fine("Processing plugin " + this.plugin.getPluginTitle());
        StringBuffer template = new StringBuffer(this.plugin.getPluginContents());
        try {
            pods = PodFactory.createPods(template);
        }
        catch (PodTagFormatException e) {
            logger.finer(e.getMessage());
            JOptionPane.showMessageDialog(this.parent, e.getMessage(), TextPool.getString("titleErrorMessage"), 0);
            return;
        }
        int timeFrame = 100;
        logger.fine("Checking for action pods");
        for (Pod pod : pods) {
            ActionPod actionPod;
            if (!pod.isActionPod() || !(actionPod = (ActionPod)((Object)pod)).isActionPodType(ActionPodType.ASK_FOR_TIMEFRAME)) continue;
            logger.fine("Action: Time frame selection");
            TimeFrameSelectionDialog dialog = new TimeFrameSelectionDialog(this.parent);
            dialog.setVisible(true);
            int selectedTimeFrame = dialog.getSelectedTimeFrame();
            logger.finer("Selected time frame: " + selectedTimeFrame);
            if (selectedTimeFrame > 0) {
                logger.finer("Setting selected time frame to " + selectedTimeFrame);
                timeFrame = selectedTimeFrame;
            }
            if (!(actionPod instanceof SimplePod)) continue;
            SimplePod simplePod = (SimplePod)actionPod;
            simplePod.setResult(TimeFrame.toString(timeFrame));
        }
        List<AbstractReceipt> rl = ReceiptGroupManager.getInstance().getReceiptCollectionByTimeFrame(timeFrame);
        List<Integer> poolYears = PoolManager.getInstance().getContainedYears();
        for (Integer year : poolYears) {
            rl.add(PoolManager.getInstance().getDepreciationPoolForYear(year));
        }
        ReceiptWalker walker = new ReceiptWalker(rl);
        PodsProcessor podsProcessor = new PodsProcessor(pods);
        walker.addReceiptProcessor(podsProcessor);
        walker.run();
        Collection<Integer> untouchedAccounts = podsProcessor.getUntouchedAccounts();
        Iterator<Integer> untouchedAccount = untouchedAccounts.iterator();
        block4: while (untouchedAccount.hasNext()) {
            int account = untouchedAccount.next();
            for (Pod pod : pods) {
                if (!pod.collectsAccount(account)) continue;
                untouchedAccount.remove();
                continue block4;
            }
        }
        for (Pod pod : pods) {
            int pos = template.indexOf(pod.getTag());
            template.replace(pos, pos + pod.getTag().length(), pod.getResultString());
        }
        if (untouchedAccounts.size() > 0) {
            int count = 0;
            StringBuilder stringBuilder = new StringBuilder(untouchedAccounts.size() * 6 + 10);
            for (Integer account : untouchedAccounts) {
                stringBuilder.append(account.toString());
                stringBuilder.append(", ");
                if (++count == 18) {
                    stringBuilder.append('\n');
                }
                count %= 18;
            }
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            JOptionPane.showMessageDialog(this.parent, String.valueOf(TextPool.getString("msgPluginHasNotTouchedAllAccounts")) + stringBuilder.toString(), TextPool.getString("titlePluginWarning"), 2);
        }
        DataCenter.getInstance().showHTML(template);
    }
}

