/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.kernels.KernelPoolList;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.AbstractToolbarAction;
import de.uwemock.guitools.StandardDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JRadioButton;

public class ActionPoolList
extends AbstractToolbarAction {
    private JFrame parent;

    public ActionPoolList(JFrame parent, String resourceIconSmall, String resourceIconLarge) {
        super(TextPool.getString("menuPoolList"), resourceIconSmall, resourceIconLarge);
        this.parent = parent;
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        PoolExpansionPanel pep = new PoolExpansionPanel();
        StandardDialog dialog = new StandardDialog((Frame)this.parent, TextPool.getString("titlePoolDetails"), pep);
        dialog.setVisible(true);
        if (dialog.getResult() == 1) {
            KernelPoolList k = new KernelPoolList(PoolManager.getInstance(), DataCenter.getInstance().getBusinessYear(), pep.getExpandPools(), false);
            StringBuffer html = null;
            try {
                html = (StringBuffer)k.executeWork();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (html != null) {
                DataCenter.getInstance().showHTML(html);
            }
        }
        dialog.dispose();
    }

    private static class PoolExpansionPanel
    extends AbstractStandardDialogPanel {
        private JRadioButton buttonExpandPools = new JRadioButton(TextPool.getString("labelExpandPools"));
        private JRadioButton buttonSummaryOnly = new JRadioButton(TextPool.getString("labelPoolSummaryOnly"));
        private boolean expandPools;

        public PoolExpansionPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.buttonExpandPools);
            this.add(this.buttonSummaryOnly);
            this.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titlePoolDetails")));
            ButtonGroup group = new ButtonGroup();
            group.add(this.buttonExpandPools);
            group.add(this.buttonSummaryOnly);
        }

        @Override
        public void dialogOpens() {
            this.buttonExpandPools.setSelected(true);
        }

        @Override
        public void saveDialogData() {
            this.expandPools = this.buttonExpandPools.isSelected();
        }

        @Override
        public Component getComponent() {
            return this;
        }

        @Override
        public String getTitle() {
            return TextPool.getString("titlePoolDetails");
        }

        @Override
        public void setOkAction(Action okAction) {
        }

        public boolean getExpandPools() {
            return this.expandPools;
        }

        @Override
        public void dispose() {
        }
    }
}

