/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.Tax;
import de.uwemock.eur.data.TaxList;
import de.uwemock.eur.gui.JesIcons;
import de.uwemock.eur.gui.PaymentTemplateSettingsPanel;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.PaymentTemplate;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.SimpleReceipt;
import de.uwemock.guitools.StandardDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.MutableComboBoxModel;

public class ActionPaymentTemplateFromReceipt
extends AbstractAction {
    private Frame parent;
    private Receipt receipt;
    private MutableComboBoxModel templateList;

    public ActionPaymentTemplateFromReceipt(Frame parent, Receipt receipt, MutableComboBoxModel templateList) {
        super(TextPool.getString("menuPopupNewPaymentTemplateFromReceipt"));
        this.putValue("SmallIcon", JesIcons.iconTemplate);
        this.parent = parent;
        this.receipt = receipt;
        this.templateList = templateList;
        this.setEnabled(receipt instanceof SimpleReceipt);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        PaymentTemplate template = new PaymentTemplate(TextPool.getString("titleNewPaymentTemplate"));
        if (this.receipt instanceof SimpleReceipt) {
            SimpleReceipt simpleReceipt = (SimpleReceipt)this.receipt;
            template.setAccountNumber(simpleReceipt.getAccount());
            template.setAmount(simpleReceipt.getAmountIncludingTax());
            template.setDescription(simpleReceipt.getReceiptDescription());
            template.setIncludingExcludingTax(0);
            TaxList taxList = DataCenter.getInstance().getTaxList();
            for (Tax tax : taxList) {
                if (!simpleReceipt.getTaxKey().equals(tax.getTaxKey())) continue;
                template.setTaxID(tax.getID());
            }
        }
        PaymentTemplateSettingsPanel panel = new PaymentTemplateSettingsPanel();
        panel.setTemplate(template);
        StandardDialog dialog = new StandardDialog(this.parent, TextPool.getString("titleNewPaymentTemplate"), panel);
        dialog.setVisible(true);
        if (dialog.getResult() == 1) {
            panel.saveToTemplate(template);
            this.templateList.addElement(template);
        }
    }
}

