/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.gui.JesIcons;
import de.uwemock.eur.gui.ReceiptDataException;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.undo.JesUndoManager;
import de.uwemock.eur.gui.undo.PartialPaymentEdit;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.eur.receipt.gui.PartialPaidReceiptPanel;
import de.uwemock.guitools.StandardDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class ActionPartialPayment
extends AbstractAction {
    private Frame parent;
    private AbstractReceipt receipt;
    private ReceiptGroupManager receiptOwner;

    public ActionPartialPayment(Frame parent, AbstractReceipt r, ReceiptGroupManager owner) {
        super(TextPool.getString("menuPopupPartialPayment"));
        this.putValue("SmallIcon", JesIcons.iconPartPaid);
        this.parent = parent;
        this.receipt = r;
        this.receiptOwner = owner;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.receipt.isPaid()) {
            PartialPaidReceiptPanel panel = new PartialPaidReceiptPanel(this.receipt);
            StandardDialog dialog = new StandardDialog(this.parent, TextPool.getString("titlePartialPayment"), panel);
            dialog.setVisible(true);
            if (dialog.getResult() == 2) {
                return;
            }
            try {
                AbstractReceipt newRemainingReceipt = panel.getNewRemainingReceipt();
                AbstractReceipt newOriginalReceipt = panel.getNewOriginalReceipt();
                this.receiptOwner.replace(this.receipt, newOriginalReceipt);
                newOriginalReceipt.setChanged();
                newOriginalReceipt.notifyObservers();
                this.receiptOwner.add(newRemainingReceipt);
                JesUndoManager.getInstance().addEdit(new PartialPaymentEdit(this.receipt, newOriginalReceipt, newRemainingReceipt, this.receiptOwner));
            }
            catch (ReceiptDataException e1) {
                JOptionPane.showMessageDialog(dialog, e1.getMessage(), TextPool.getString("titleReceiptCreationError"), 0);
            }
        }
    }
}

