/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.FilenameExtensions;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.gui.JesFileChooser;
import de.uwemock.eur.gui.MainWindow;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.kernels.KernelReadEuxFile;
import de.uwemock.guitools.AbstractToolbarAction;
import de.uwemock.guitools.ProgressBarForRunnable;
import de.uwemock.guitools.RunnableResultReceiver;
import de.uwemock.kernel.ProgressBarAdapterForKernel;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Calendar;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ActionOpenFile
extends AbstractToolbarAction {
    private MainWindow parent;
    private String fileToOpen;

    public ActionOpenFile(MainWindow parent, String resourceIconSmall, String resourceIconLarge) {
        super(TextPool.getString("menuFileOpen"), resourceIconSmall, resourceIconLarge);
        this.parent = parent;
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    public ActionOpenFile(MainWindow parent, String fileToOpen) {
        this(parent, null, null);
        this.fileToOpen = fileToOpen;
        this.putValue("Name", fileToOpen);
        this.putValue("ShortDescription", fileToOpen);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String filename;
        if (DataCenter.getInstance().dataHasChanged()) {
            int res = JOptionPane.showConfirmDialog(this.parent, TextPool.getString("msgDataChangedAtEnd"), TextPool.getString("titleOpenFile"), 1);
            if (res == 2) {
                return;
            }
            if (res == 0) {
                this.parent.saveData();
            }
        }
        if ((filename = this.fileToOpen) == null) {
            File chosen;
            JesFileChooser dialog = new JesFileChooser();
            dialog.setFileFilter(FilenameExtensions.fileFilterEurFiles);
            int res = dialog.showOpenDialog(this.parent);
            if (res == 0 && (chosen = dialog.getSelectedFile()) != null) {
                filename = chosen.getAbsolutePath();
            }
        }
        if (filename != null) {
            File chosen = new File(filename);
            SettingsManager.getInstance().setLastDirectoryUsed(chosen.getParent());
            KernelReadEuxFile k = new KernelReadEuxFile(filename);
            ProgressBarAdapterForKernel<KernelReadEuxFile> adapterForKernel = new ProgressBarAdapterForKernel<KernelReadEuxFile>(k);
            ProgressBarForRunnable progressBar = new ProgressBarForRunnable(this.parent, adapterForKernel, new RunnableResultReceiver(){

                @Override
                public void processResult(Object result) {
                    try {
                        ProgressBarAdapterForKernel pb = (ProgressBarAdapterForKernel)result;
                        Exception e = (Exception)pb.get("KERNEL_EXCEPTION");
                        if (e != null) {
                            throw e;
                        }
                        DataCenter.getInstance().getAllDataFromKernel((KernelReadEuxFile)pb.getKernel());
                        Calendar today = Calendar.getInstance();
                        if (today.get(1) == DataCenter.getInstance().getBusinessYear()) {
                            ActionOpenFile.this.parent.getMainTablePanel().setSelectedMonth(today.get(2) + 1);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ActionOpenFile.this.parent.setSaveActionEnabled(false);
                            }
                        });
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(ActionOpenFile.this.parent, ex.getMessage(), TextPool.getString("titleErrorMessage"), 0);
                    }
                }
            });
            progressBar.setText(TextPool.getString("msgLoadingFile"));
            progressBar.start();
        }
    }
}

