/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.FileContext;
import de.uwemock.eur.data.FilenameExtensions;
import de.uwemock.eur.data.TaxList;
import de.uwemock.eur.gui.JesFileChooser;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.xmltools.XmlTools;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ActionImportTaxSettings
extends AbstractAction {
    private Frame parent;

    public ActionImportTaxSettings(Frame parent) {
        super(TextPool.getString("buttonImport"));
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String filename;
        JesFileChooser d = new JesFileChooser();
        d.setFileFilter(FilenameExtensions.fileFilterTaxFiles);
        if (d.showOpenDialog(this.parent) == 0 && (filename = d.getSelectedFile().getAbsolutePath()) != null) {
            Logger logger = Logger.getLogger("de.uwemock.eur.ActionImportTaxSettings");
            TaxList newTaxList = null;
            XMLStreamReader reader = null;
            Reader xmlReaderFromFileContext = null;
            FileInputStream fileInputStream = null;
            try {
                try {
                    boolean hasNext;
                    FileContext context = new FileContext(filename);
                    xmlReaderFromFileContext = context.getXMLDataStream();
                    XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                    reader = inputFactory.createXMLStreamReader(xmlReaderFromFileContext);
                    do {
                        if (reader.hasName() && reader.isStartElement() && XmlTools.isStartElement(reader, "taxlist")) {
                            logger.finer("Found tax list");
                            newTaxList = TaxList.readFromXML(reader);
                        }
                        if (!(hasNext = reader.hasNext())) continue;
                        reader.next();
                    } while (hasNext);
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgFileNotFound"), TextPool.getString("titleErrorMessage"), 0);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (XMLStreamException ex2) {
                            ex2.printStackTrace();
                        }
                    }
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException ex3) {
                            ex3.printStackTrace();
                        }
                    }
                    return;
                }
                catch (Exception ex) {
                    block35: {
                        JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgGeneralDataReadError"), TextPool.getString("titleErrorMessage"), 0);
                        if (reader == null) break block35;
                        try {
                            reader.close();
                        }
                        catch (XMLStreamException ex4) {
                            ex4.printStackTrace();
                        }
                    }
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException ex5) {
                            ex5.printStackTrace();
                        }
                    }
                    return;
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (XMLStreamException ex) {
                        ex.printStackTrace();
                    }
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (newTaxList != null) {
                String message = String.format(TextPool.getString("msgTaxSettingsRead"), newTaxList.size());
                int res = JOptionPane.showConfirmDialog(this.parent, message, TextPool.getString("titleAboutToImportTaxSettings"), 0);
                if (res == 0) {
                    DataCenter.getInstance().setTaxList(newTaxList);
                }
            } else {
                JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgTaxSettingsNotFound"), TextPool.getString("titleInformation"), 1);
            }
        }
    }
}

