/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.calculation.plugins.AbstractEurPlugin;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.FileContext;
import de.uwemock.eur.data.FilenameExtensions;
import de.uwemock.eur.gui.JesFileChooser;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.xmltools.XmlTools;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ActionImportPlugins
extends AbstractAction {
    private Window parent;

    public ActionImportPlugins(Window parent) {
        super(TextPool.getString("buttonImport"));
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String filename;
        JesFileChooser d = new JesFileChooser();
        d.setFileFilter(FilenameExtensions.fileFilterPluginFiles);
        if (d.showOpenDialog(this.parent) == 0 && (filename = d.getSelectedFile().getAbsolutePath()) != null) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            ArrayList<AbstractEurPlugin> newPluginsList = null;
            XMLStreamReader reader = null;
            Reader xmlReaderFromFileContext = null;
            FileInputStream fileInputStream = null;
            try {
                try {
                    boolean hasNext;
                    FileContext context = new FileContext(filename);
                    xmlReaderFromFileContext = context.getXMLDataStream();
                    XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                    reader = inputFactory.createXMLStreamReader(xmlReaderFromFileContext);
                    do {
                        if (reader.hasName() && reader.isStartElement() && XmlTools.isStartElement(reader, "plugins")) {
                            logger.finer("Found plugins list");
                            newPluginsList = new ArrayList<AbstractEurPlugin>();
                            while (reader.hasNext()) {
                                reader.next();
                                if (XmlTools.isEndElement(reader, "plugins")) break;
                                if (!XmlTools.isStartElement(reader, "plugin")) continue;
                                logger.finer("Plugin...");
                                AbstractEurPlugin plugin = AbstractEurPlugin.readFromXML(reader, DataCenter.getInstance().getAccountList(), DataCenter.getInstance().getTaxList());
                                if (plugin == null) continue;
                                newPluginsList.add(plugin);
                            }
                        }
                        if (!(hasNext = reader.hasNext())) continue;
                        reader.next();
                    } while (hasNext);
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgFileNotFound"), TextPool.getString("titleErrorMessage"), 0);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (XMLStreamException ex2) {
                            ex2.printStackTrace();
                        }
                    }
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException ex3) {
                            ex3.printStackTrace();
                        }
                    }
                    return;
                }
                catch (Exception ex) {
                    block37: {
                        JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgGeneralDataReadError"), TextPool.getString("titleErrorMessage"), 0);
                        if (reader == null) break block37;
                        try {
                            reader.close();
                        }
                        catch (XMLStreamException ex4) {
                            ex4.printStackTrace();
                        }
                    }
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException ex5) {
                            ex5.printStackTrace();
                        }
                    }
                    return;
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (XMLStreamException ex) {
                        ex.printStackTrace();
                    }
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (newPluginsList != null) {
                String message = String.format(TextPool.getString("msgPluginsRead"), newPluginsList.size());
                int res = JOptionPane.showConfirmDialog(this.parent, message, TextPool.getString("titleAboutToImportPlugins"), 0);
                if (res == 0) {
                    ArrayList<AbstractEurPlugin> currentPluginsList = DataCenter.getInstance().getPluginList();
                    for (AbstractEurPlugin p : newPluginsList) {
                        currentPluginsList.add(p);
                    }
                    DataCenter.getInstance().setPluginList(currentPluginsList);
                }
            } else {
                JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgPluginsNotFound"), TextPool.getString("titleInformation"), 1);
            }
        }
    }
}

