/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.datetools.Date;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.PoolDepreciationStrategy;
import de.uwemock.eur.gui.ImportDepreciationReceiptsPanel;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.kernels.KernelReadEuxFile;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.DepreciationPool;
import de.uwemock.eur.receipt.OldDepreciationPool;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.eur.receipt.ReceiptNumberManager;
import de.uwemock.guitools.StandardDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ActionImportDepreciationReceipts
extends AbstractAction {
    private JFrame parent;

    public ActionImportDepreciationReceipts(JFrame parent) {
        super(TextPool.getString("menuImportDepreciationReceipts"));
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int res;
        int currentBusinessYear = DataCenter.getInstance().getBusinessYear();
        Date firstDayOfYear = Date.getDate(currentBusinessYear, 1, 1);
        PoolManager poolManager = PoolManager.getInstance();
        List<Integer> yearList = poolManager.getContainedYears();
        yearList.remove((Object)currentBusinessYear);
        if (yearList.size() > 0 && (res = JOptionPane.showConfirmDialog(this.parent, TextPool.getString("msgDepreciationPoolsAlreadyPresent"), TextPool.getString("titleInformation"), 0, 2)) != 0) {
            return;
        }
        ImportDepreciationReceiptsPanel idrp = new ImportDepreciationReceiptsPanel();
        StandardDialog dialog = new StandardDialog((Frame)this.parent, TextPool.getString("titleImportDepreciationReceipts"), idrp);
        dialog.setVisible(true);
        if (dialog.getResult() == 1) {
            KernelReadEuxFile k = new KernelReadEuxFile(idrp.getFilename());
            try {
                k.executeWork();
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgFileNotFound"), TextPool.getString("titleErrorMessage"), 0);
                return;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.parent, ex.getMessage(), TextPool.getString("titleErrorMessage"), 0);
                return;
            }
            boolean importReceipts = idrp.doImportReceipts();
            boolean importPools = idrp.doImportPools();
            int countPoolsAccepted = 0;
            int countNonPoolReceiptsAccepted = 0;
            int countReceiptsExpired = 0;
            LinkedList receipts = (LinkedList)k.get("RECEIPTS_LIST");
            LinkedList importedPoolsList = (LinkedList)k.get("DEPRECIATION_POOLS");
            for (AbstractReceipt r : receipts) {
                if (!r.hasDepreciationStrategy()) continue;
                if (r.getDepreciationStrategy().isDepreciatedInYear(currentBusinessYear)) {
                    if (r instanceof OldDepreciationPool) {
                        if (!importPools) continue;
                        int year = r.getDate().getYear();
                        DepreciationPool pool = PoolManager.getInstance().getDepreciationPoolForYear(year);
                        DepreciationStrategy ds = r.getDepreciationStrategy();
                        if (!(ds instanceof PoolDepreciationStrategy)) {
                            ds = new PoolDepreciationStrategy(ds.getStartYear(), ds.getNumYears() + 1, pool);
                        }
                        pool.setDepreciationStrategy(ds);
                        for (AbstractReceipt containedReceipt : ((OldDepreciationPool)r).getReceiptList()) {
                            int newReceiptNumber = ReceiptNumberManager.getInstance().getNextReceiptNumber();
                            containedReceipt.setNumber(newReceiptNumber);
                            PoolManager.getInstance().add(containedReceipt);
                        }
                        ++countPoolsAccepted;
                        continue;
                    }
                    if (!importReceipts) continue;
                    ++countNonPoolReceiptsAccepted;
                    r.setNumber(ReceiptNumberManager.getInstance().getNextReceiptNumber());
                    r.setDate(firstDayOfYear);
                    ReceiptGroupManager.getInstance().add(r);
                    continue;
                }
                ++countReceiptsExpired;
            }
            if (importPools && importedPoolsList != null) {
                for (DepreciationPool pool : importedPoolsList) {
                    DepreciationStrategy ds = pool.getDepreciationStrategy();
                    if (ds.isDepreciatedInYear(currentBusinessYear)) {
                        int startYear = ds.getStartYear();
                        DepreciationPool newPool = PoolManager.getInstance().getDepreciationPoolForYear(startYear);
                        for (AbstractReceipt r : pool.getReceiptList()) {
                            r.setNumber(ReceiptNumberManager.getInstance().getNextReceiptNumber());
                            newPool.add(r);
                        }
                        ++countPoolsAccepted;
                        continue;
                    }
                    ++countReceiptsExpired;
                }
            }
            String message = String.format(TextPool.getString("msgImportDone"), countNonPoolReceiptsAccepted, countPoolsAccepted, countReceiptsExpired);
            JOptionPane.showMessageDialog(this.parent, message);
        }
        dialog.dispose();
    }
}

