/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.FilenameExtensions;
import de.uwemock.eur.gui.JesFileChooser;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.kernels.KernelImportAccounts;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.xml.stream.XMLStreamException;

public class ActionImportAccountSettings
extends AbstractAction {
    private Component parent;

    public ActionImportAccountSettings(Component parent) {
        super(TextPool.getString("buttonImport"));
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String filename;
        JesFileChooser d = new JesFileChooser();
        d.setFileFilter(FilenameExtensions.fileFilterAccountFiles);
        if (d.showOpenDialog(this.parent) == 0 && (filename = d.getSelectedFile().getAbsolutePath()) != null) {
            KernelImportAccounts k = new KernelImportAccounts(filename);
            AccountList newAccountList = null;
            try {
                newAccountList = (AccountList)k.executeWork();
            }
            catch (XMLStreamException ex) {
                JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgGeneralDataReadError"), TextPool.getString("titleErrorMessage"), 0);
                return;
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgFileNotFound"), TextPool.getString("titleErrorMessage"), 0);
                return;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgGeneralDataReadError"), TextPool.getString("titleErrorMessage"), 0);
                return;
            }
            if (newAccountList != null) {
                String message = String.format(TextPool.getString("msgAccountSettingsRead"), newAccountList.size());
                int res = JOptionPane.showConfirmDialog(this.parent, message, TextPool.getString("titleAboutToImportAccountSettings"), 0);
                if (res == 0) {
                    DataCenter.getInstance().setAccountList(newAccountList);
                }
            } else {
                JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgAccountSettingsNotFound"), TextPool.getString("titleInformation"), 1);
            }
        }
    }
}

