/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.gui.JesFileChooser;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.tools.LoggingManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ActionExportTaxes
extends AbstractAction {
    private JFrame parent;

    public ActionExportTaxes(JFrame parent) {
        super(TextPool.getString("menuExportTaxes"));
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Logger logger = Logger.getLogger("de.uwemock.eur.ActionExportTaxes");
        JesFileChooser d = new JesFileChooser();
        d.showSaveDialog(this.parent);
        if (d.getSelectedFile() != null && !d.getSelectedFile().isDirectory()) {
            String filename = d.getSelectedFile().getAbsolutePath();
            logger.finest("User entered filename " + filename);
            if (!filename.endsWith(".eut")) {
                filename = String.valueOf(filename) + ".eut";
            }
            logger.finest("Filename with extension: " + filename);
            File file = new File(filename);
            if (file.exists()) {
                logger.finest("File exists; will ask user what to do...");
                int res = JOptionPane.showConfirmDialog(this.parent, TextPool.getString("msgFileExists"), TextPool.getString("titleOverwriteMessage"), 0);
                if (res == 1) {
                    return;
                }
                logger.finest("User says: overwrite.");
            }
            XMLStreamWriter writer = null;
            OutputStream fileOutputStream = null;
            try {
                try {
                    File canonicalFile = file.getCanonicalFile();
                    logger.finest("About to write file " + filename + " as " + canonicalFile.getCanonicalPath());
                    if (SettingsManager.getInstance().doCreateBackup() && file.exists()) {
                        logger.finest("File exists; trying to create backup file.");
                        File fileBackup = new File(String.valueOf(canonicalFile.getCanonicalPath()) + "~");
                        if (fileBackup.exists() && !fileBackup.delete()) {
                            logger.finest("Deleting the backup file failed");
                        }
                        if (!fileBackup.exists() && !canonicalFile.renameTo(fileBackup)) {
                            logger.finest("Renaming the previous file failed");
                        }
                    }
                    logger.finest("About to create XML stream...");
                    XMLOutputFactory factory = XMLOutputFactory.newInstance();
                    fileOutputStream = new FileOutputStream(canonicalFile);
                    writer = factory.createXMLStreamWriter(fileOutputStream, "UTF-8");
                    logger.finest("Starting to write on XML stream...");
                    writer.writeStartDocument("UTF-8", "1.0");
                    writer.writeStartElement("eur");
                    logger.finest("Writing taxes...");
                    DataCenter.getInstance().getTaxList().writeToXML(writer);
                    writer.writeEndElement();
                    logger.finest("Done writing.");
                    writer.writeEndDocument();
                }
                catch (IOException ex) {
                    LoggingManager.logException(this.getClass(), ex);
                    JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgFileNotAccessible"), TextPool.getString("titleErrorMessage"), 0);
                    if (writer != null) {
                        try {
                            writer.flush();
                            writer.close();
                        }
                        catch (XMLStreamException xMLStreamException) {
                            // empty catch block
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.flush();
                            ((FileOutputStream)fileOutputStream).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (XMLStreamException ex) {
                    block36: {
                        LoggingManager.logException(this.getClass(), ex);
                        JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgWriteError"), TextPool.getString("titleErrorMessage"), 0);
                        if (writer == null) break block36;
                        try {
                            writer.flush();
                            writer.close();
                        }
                        catch (XMLStreamException xMLStreamException) {
                            // empty catch block
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.flush();
                            ((FileOutputStream)fileOutputStream).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (XMLStreamException xMLStreamException) {}
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.flush();
                        ((FileOutputStream)fileOutputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

