/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.gui.JesIcons;
import de.uwemock.eur.gui.ReceiptDataException;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.undo.EditReceiptEdit;
import de.uwemock.eur.gui.undo.JesUndoManager;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.eur.receipt.gui.AbstractReceiptInput;
import de.uwemock.eur.receipt.gui.ReceiptInputChain;
import de.uwemock.guitools.StandardDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class ActionEditReceipt
extends AbstractAction {
    private Frame parent;
    private AbstractReceipt oldReceipt;
    private ReceiptGroupManager receiptOwner;
    AbstractReceiptInput input = null;

    public ActionEditReceipt(Frame parent, AbstractReceipt r, ReceiptGroupManager owner) {
        super(TextPool.getString("menuPopupEditReceipt"));
        this.putValue("SmallIcon", JesIcons.iconEdit);
        this.parent = parent;
        this.oldReceipt = r;
        this.receiptOwner = owner;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.oldReceipt.isEditable()) {
            return;
        }
        this.input = ReceiptInputChain.getReceiptInputFor(this.oldReceipt);
        if (this.input != null) {
            this.input.setParentFrame(this.parent);
            this.input.setReceiptContents(this.oldReceipt);
            StandardDialog dialog = new StandardDialog(this.parent, this.input.getTitle(), this.input);
            dialog.setVisible(true);
            if (dialog.getResult() == 1) {
                try {
                    AbstractReceipt newReceipt = this.input.createYourReceiptNow();
                    this.receiptOwner.replace(this.oldReceipt, newReceipt);
                    newReceipt.setChanged();
                    newReceipt.notifyObservers();
                    JesUndoManager.getInstance().addEdit(new EditReceiptEdit(this.oldReceipt, newReceipt, this.receiptOwner));
                }
                catch (ReceiptDataException e1) {
                    JOptionPane.showMessageDialog(dialog, e1.getMessage(), TextPool.getString("titleReceiptCreationError"), 0);
                }
            }
            dialog.dispose();
        } else {
            JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgReceiptEditorNotFound"), TextPool.getString("titleReceiptEditorNotFound"), 0);
        }
    }
}

