/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.ExtraDepreciation;
import de.uwemock.eur.depreciation.gui.ExtraDepreciationEditPanel;
import de.uwemock.eur.gui.JesIcons;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.undo.AddExtraDepreciationEdit;
import de.uwemock.eur.gui.undo.EditExtraDepreciationEdit;
import de.uwemock.eur.gui.undo.JesUndoManager;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.guitools.StandardDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class ActionEditExtraDepreciation
extends AbstractAction {
    private int businessYear;
    private Frame parent;
    private AbstractReceipt receipt;
    private boolean editAllowed;

    public ActionEditExtraDepreciation(Frame parent, AbstractReceipt r, int businessYear, String title) {
        this(parent, r, businessYear, title, true);
    }

    public ActionEditExtraDepreciation(Frame parent, AbstractReceipt r, int businessYear, String title, boolean editAllowed) {
        super(title);
        this.putValue("SmallIcon", JesIcons.iconEditDepreciation);
        this.parent = parent;
        this.receipt = r;
        this.businessYear = businessYear;
        this.editAllowed = editAllowed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean hasHadExtraDepreciation;
        ExtraDepreciation ed;
        DepreciationStrategy ds = this.receipt.getDepreciationStrategy();
        if (ds == null) {
            return;
        }
        ExtraDepreciation oldDepreciation = ed = ds.getExtraDepreciation();
        boolean bl = hasHadExtraDepreciation = ed != null;
        if (ed == null) {
            ed = new ExtraDepreciation(ds.getStartYear());
        }
        ExtraDepreciationEditPanel editPanel = new ExtraDepreciationEditPanel(ed, this.businessYear);
        StandardDialog dialog = new StandardDialog(this.parent, TextPool.getString("titleExtraDeprecitaion"), editPanel);
        dialog.setVisible(true);
        if (this.editAllowed && dialog.getResult() == 1) {
            ExtraDepreciation newDepreciation = editPanel.getExtraDepreciation();
            ds.setExtraDepreciation(newDepreciation);
            if (hasHadExtraDepreciation) {
                JesUndoManager.getInstance().addEdit(new EditExtraDepreciationEdit(this.receipt, oldDepreciation, newDepreciation));
            } else {
                JesUndoManager.getInstance().addEdit(new AddExtraDepreciationEdit(this.receipt, newDepreciation));
            }
        }
        dialog.dispose();
        this.receipt.notifyObservers();
    }
}

