/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.depreciation.DefaultDepreciationStrategy;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.gui.AbstractDepreciationEditor;
import de.uwemock.eur.depreciation.gui.DepreciationAssistant;
import de.uwemock.eur.gui.JesIcons;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.undo.AddDepreciationEdit;
import de.uwemock.eur.gui.undo.EditDepreciationEdit;
import de.uwemock.eur.gui.undo.JesUndoManager;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.DepreciationPool;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.StandardDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class ActionEditDepreciationStrategy
extends AbstractAction {
    private int businessYear;
    private Frame parent;
    private AbstractReceipt receipt;
    private boolean editAllowed;

    public ActionEditDepreciationStrategy(Frame parent, AbstractReceipt r, int businessYear) {
        this(parent, r, businessYear, true);
    }

    public ActionEditDepreciationStrategy(Frame parent, AbstractReceipt r, int businessYear, boolean editAllowed) {
        super(editAllowed ? TextPool.getString("menuPopupEditDepreciation") : TextPool.getString("menuPopupShowDepreciation"));
        this.putValue("SmallIcon", JesIcons.iconEditDepreciation);
        this.parent = parent;
        this.receipt = r;
        this.businessYear = businessYear;
        this.editAllowed = editAllowed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DepreciationStrategy oldDepreciation = this.receipt.getDepreciationStrategy();
        if (SettingsManager.getInstance().useDepreciationAssistant() && !(this.receipt instanceof DepreciationPool)) {
            DepreciationAssistant sdp = new DepreciationAssistant(this.receipt.getDepreciationStrategy(), this.businessYear, this.receipt, this.editAllowed);
            StandardDialog dialog = new StandardDialog(this.parent, TextPool.getString("titleEditDepreciation"), sdp);
            dialog.setVisible(true);
            dialog.dispose();
        } else {
            DepreciationStrategy strategy;
            AbstractDepreciationEditor editPanel;
            if (this.receipt.getDepreciationStrategy() == null) {
                this.receipt.setDepreciationStrategy(new DefaultDepreciationStrategy(this.businessYear, 5, this.receipt));
            }
            if ((editPanel = (strategy = this.receipt.getDepreciationStrategy()).getDepreciationEditor(this.businessYear, this.receipt)) != null) {
                if (!this.editAllowed) {
                    GuiTools.setAllComponentsEnabled(editPanel, this.editAllowed);
                }
                StandardDialog dialog = new StandardDialog(this.parent, TextPool.getString("titleEditDepreciation"), editPanel);
                dialog.setVisible(true);
                if (this.editAllowed && dialog.getResult() == 1) {
                    this.receipt.setDepreciationStrategy(editPanel.getDepreciationStrategy());
                    this.receipt.notifyObservers();
                    DataCenter.getInstance().setDataChanged();
                }
                dialog.dispose();
            } else {
                JOptionPane.showMessageDialog(this.parent, TextPool.getString("msgDepreciationEditorNotFound"), TextPool.getString("titleDepreciationEditorNotFound"), 0);
            }
        }
        if (this.editAllowed) {
            if (oldDepreciation == null) {
                JesUndoManager.getInstance().addEdit(new AddDepreciationEdit(this.receipt, this.receipt.getDepreciationStrategy()));
            } else {
                JesUndoManager.getInstance().addEdit(new EditDepreciationEdit(this.receipt, oldDepreciation, this.receipt.getDepreciationStrategy()));
            }
        }
    }
}

