/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.gui.actions;

import de.uwemock.eur.accounts.gui.AccountComboBox;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.DecliningBalanceDepreciationStrategy;
import de.uwemock.eur.depreciation.DefaultDepreciationStrategy;
import de.uwemock.eur.depreciation.ExtraDepreciation;
import de.uwemock.eur.depreciation.PoolDepreciationStrategy;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.StandardDialog;
import de.uwemock.guitools.StandardDialogPanel;
import de.uwemock.guitools.StandardDialogStackPanel;
import de.uwemock.settings.SettingPanel;
import de.uwemock.settings.SettingsCluster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ActionEditDepreciationRules
extends AbstractAction {
    private JFrame parent;

    public ActionEditDepreciationRules(JFrame parent) {
        super(TextPool.getString("menuSettingsDepreciationRules"));
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        StandardDialog d = new StandardDialog((Frame)this.parent, TextPool.getString("titleDataGeneral"));
        SettingsCluster[] cluster = new SettingsCluster[]{DefaultDepreciationStrategy.getSettingsCluster(), DecliningBalanceDepreciationStrategy.getSettingsCluster(), PoolDepreciationStrategy.getSettingsCluster(), ExtraDepreciation.getSettingsCluster()};
        String[] titles = new String[]{TextPool.getString("titleDepreciationLinear"), TextPool.getString("titleDepreciationDeclining"), TextPool.getString("titleDepreciationPool"), TextPool.getString("titleDepreciationExtra")};
        int i = 0;
        while (i < cluster.length) {
            SettingsCluster c = cluster[i];
            d.startNewTab(titles[i]);
            d.addPanel(new AccountPanel(c));
            StandardDialogStackPanel stack = new StandardDialogStackPanel();
            Collection<String> keys = c.getSettingKeys();
            if (keys.size() > 1) {
                for (String key : keys) {
                    if ("defaultAccount".equals(key)) continue;
                    SettingPanel sdp = new SettingPanel(c.getSetting(key));
                    stack.addPanel(sdp);
                }
                stack.getComponent().setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleMiscellaneousSettings")));
                d.addPanel(stack);
            }
            ++i;
        }
        d.setVisible(true);
        this.parent.repaint();
    }

    private static class AccountPanel
    implements StandardDialogPanel {
        private JPanel panel;
        private SettingsCluster cluster;
        private AccountComboBox accountInput = new AccountComboBox(DataCenter.getInstance().getAccountList());

        public AccountPanel(SettingsCluster cluster) {
            this.cluster = cluster;
            this.panel = new JPanel(new BorderLayout());
            this.panel.setBorder(BorderFactory.createTitledBorder(this.getTitle()));
            this.panel.add((Component)this.accountInput, "Center");
        }

        @Override
        public void dialogOpens() {
            int accountNumber = ((Number)this.cluster.getSettingValue("defaultAccount")).intValue();
            this.accountInput.setSelectedAccount(accountNumber);
        }

        @Override
        public void saveDialogData() {
            int accountNumber = this.accountInput.getSelectedAccountNumber();
            this.cluster.setSettingValue("defaultAccount", accountNumber);
            DataCenter.getInstance().setDataChanged();
        }

        @Override
        public Component getComponent() {
            return this.panel;
        }

        @Override
        public String getTitle() {
            return TextPool.getString("titleDefaultAccount");
        }

        @Override
        public void setOkAction(Action okAction) {
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean mayBeCancelled() {
            return true;
        }
    }
}

